/*
 * Decompiled with CFR 0.152.
 */
package com.gw.orm.springjpa.support;

import com.gw.base.data.page.GiPageParam;
import com.gw.base.gpa.support.GwOrder;
import com.gw.base.gpa.support.GwSort;
import java.util.function.Function;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class GwSpringJpaPageHelper {
    public static Sort sortFromGwSort(GwSort sort) {
        Sort jpaSort = Sort.unsorted();
        if (sort != null) {
            for (GwOrder order : sort) {
                if (order.getPropertyFun() != null) {
                    Class cls = order.getEntityClass();
                    Sort.TypedSort sort1 = Sort.sort((Class)cls).by((Function)order.getPropertyFun());
                    if (order.getDirection() == GwOrder.Direction.DESC) {
                        jpaSort = jpaSort.and(sort1.descending());
                        continue;
                    }
                    jpaSort = jpaSort.and((Sort)sort1);
                    continue;
                }
                if (order.getProperty() == null) continue;
                jpaSort = jpaSort.and(Sort.by((Sort.Direction)Sort.Direction.fromString((String)order.getDirection().value()), (String[])new String[]{order.getProperty()}));
            }
        }
        return jpaSort;
    }

    public static Pageable toPageable(GiPageParam pageParam) {
        int pageNum = pageParam.pageNum() - 1;
        int pageSize = pageParam.pageSize();
        PageRequest pageRequest = PageRequest.of((int)pageNum, (int)pageSize, (Sort)GwSpringJpaPageHelper.sortFromGwSort(pageParam.sort()));
        return pageRequest;
    }
}

