package com.gw.soa.dubbo;

import com.gw.soa.rpc.GiRpcProviderAdapter;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;

import java.util.Map;

@Activate(group = {CommonConstants.PROVIDER})
public class GwDubboProviderFilter extends GiRpcProviderAdapter implements Filter {

    public static final String Config_Name = "gwDubboProviderFilter";

    public GwDubboProviderFilter(){
        super("dubbo");
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Map<String, String> map = invocation.getAttachments();
        String token33 = map.get("Authorization33");

        String token3 = invocation.getAttachment("Authorization3");

        //System.out.println("Authorization33--------------:"+token33);

        //System.out.println("Authorization3--------------:"+token3);

        boolean before = this.beforeInvoke(invocation);
        if(before) {
            Result result = invoker.invoke(invocation);
            boolean after = this.afterInvoke(result);
            if(after) {
                return result;
            }
        }
        return null;
    }
}