/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.pipeline;

import com.concurrentli.SequentialQueue;
import com.northpool.commons.concurrent.BlockThreadPool;
import com.northpool.commons.concurrent.DynamicCountDownLatch;
import com.northpool.commons.pipeline.AbstractHandler;
import com.northpool.commons.pipeline.Handler;
import com.northpool.commons.pipeline.MiGzBuffer;
import com.northpool.commons.pipeline.MiGzUtil;
import com.northpool.commons.util.StringUtility;
import com.northpool.commons.util.UString;
import com.northpool.exception.UException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GunzipHandler
extends AbstractHandler
implements Handler,
AutoCloseable {
    ByteBuffer buffer;
    protected Logger logger = LoggerFactory.getLogger(GunzipHandler.class);
    private BlockThreadPool _threadPool;
    private final SequentialQueue<MiGzBuffer> _decompressedBufferQueue;
    private int currentCompressedSize;
    private byte[] currentByteBufferZip;
    private int currentByteBufferZipOffset = 0;
    private byte[] currentHeaderBuffer;
    private int currentHeaderBufferOffset = 0;
    private boolean waitUnzipData = false;
    protected AtomicLong finished;
    protected AtomicLong finishedSize;
    protected AtomicLong apply;
    protected AtomicLong applySize;
    int toRead;
    private long _currentBlock = 0L;
    DynamicCountDownLatch _count;
    AtomicReference<RuntimeException> _exception = new AtomicReference<Object>(null);
    Thread _outputThread;

    public GunzipHandler(Integer threads) {
        this.buffer = ByteBuffer.allocate(524288);
        int outputBufferCount = 2 * threads;
        this._decompressedBufferQueue = new SequentialQueue(outputBufferCount + 1);
        this._threadPool = new BlockThreadPool(threads, 100);
        this._count = new DynamicCountDownLatch(0);
        if (this.logger.isDebugEnabled()) {
            this.finished = new AtomicLong(0L);
            this.apply = new AtomicLong(0L);
            this.applySize = new AtomicLong(0L);
            this.finishedSize = new AtomicLong(0L);
        }
        this._outputThread = new Thread(() -> {
            try {
                MiGzBuffer buffer;
                while ((buffer = (MiGzBuffer)this._decompressedBufferQueue.dequeue()) != null) {
                    if (this.logger.isDebugEnabled()) {
                        long a = this.finished.getAndIncrement();
                        long size = this.finishedSize.addAndGet(buffer.getLength());
                        if (a % 50L == 0L) {
                            this.logger.debug(UString.format("\u89e3\u538b\u5757 {} \u5b8c\u6210 \u89e3\u538b\u5927\u5c0f {} ,\u603b\u5171\u89e3\u538b {}", a, StringUtility.getDataSize(buffer.getLength()), StringUtility.getDataSize(size)));
                        }
                    }
                    if (this.next != null) {
                        this.next.pushData(buffer.getData());
                    }
                    this._count.countDown(1);
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                UException.printStackTrace(e);
                this._exception.compareAndSet(null, new RuntimeException(e));
            }
        });
        this._outputThread.start();
    }

    private static int getIntFromLSBByteArray(byte[] source, int offset) {
        return Byte.toUnsignedInt(source[offset]) | Byte.toUnsignedInt(source[offset + 1]) << 8 | Byte.toUnsignedInt(source[offset + 2]) << 16 | Byte.toUnsignedInt(source[offset + 3]) << 24;
    }

    private void unzip(byte[] zipBuffer, int compressedSize) throws InterruptedException {
        byte[] _zipBuffer = zipBuffer;
        int putativeInflatedSize = GunzipHandler.getIntFromLSBByteArray(_zipBuffer, compressedSize + 4);
        byte[] outputBuffer = new byte[putativeInflatedSize];
        long block = this._currentBlock++;
        this._count.addNum(1);
        if (this.logger.isDebugEnabled()) {
            long a = this.apply.getAndIncrement();
            long size = this.applySize.addAndGet(zipBuffer.length);
            if (a % 50L == 0L) {
                this.logger.debug(UString.format("\u7533\u8bf7\u89e3\u538b\u5757 {} ,\u5927\u5c0f {} ,\u603b\u5171\u5927\u5c0f {}", a, StringUtility.getDataSize(zipBuffer.length), StringUtility.getDataSize(size)));
            }
        }
        this._threadPool.execute(() -> {
            Inflater inflater = new Inflater(true);
            try {
                inflater.reset();
                inflater.setInput(_zipBuffer, 0, compressedSize);
                int uncompressedSize = inflater.inflate(outputBuffer);
                this._decompressedBufferQueue.enqueue(block, (Object)new MiGzBuffer(outputBuffer, uncompressedSize));
            }
            catch (InterruptedException | DataFormatException e) {
                this._exception.compareAndSet(null, new RuntimeException(e));
            }
            finally {
                inflater.end();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean _pushToUnzip() throws InterruptedException {
        if (!this.waitUnzipData) {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            if (this.currentHeaderBufferOffset == 0) {
                this.currentHeaderBuffer = new byte[MiGzUtil.GZIP_HEADER_SIZE];
                if (this.buffer.remaining() < MiGzUtil.GZIP_HEADER_SIZE) {
                    int length = this.buffer.remaining();
                    this.buffer.get(this.currentHeaderBuffer, this.currentHeaderBufferOffset, length);
                    this.currentHeaderBufferOffset = length;
                    return false;
                }
                this.buffer.get(this.currentHeaderBuffer);
            } else {
                this.buffer.get(this.currentHeaderBuffer, this.currentHeaderBufferOffset, MiGzUtil.GZIP_HEADER_SIZE - this.currentHeaderBufferOffset);
                this.currentHeaderBufferOffset = 0;
            }
            this.waitUnzipData = true;
            this.currentCompressedSize = GunzipHandler.getIntFromLSBByteArray(this.currentHeaderBuffer, this.currentHeaderBuffer.length - 4);
            int toRead = this.currentCompressedSize + 8;
            this.currentByteBufferZip = new byte[toRead];
            if (this.buffer.limit() - this.buffer.position() >= toRead) {
                System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, 0, toRead);
                this.buffer.position(this.buffer.position() + toRead);
                this.unzip(this.currentByteBufferZip, this.currentCompressedSize);
                this.waitUnzipData = false;
                return true;
            }
            System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, 0, this.buffer.limit() - this.buffer.position());
            this.currentByteBufferZipOffset = this.buffer.limit() - this.buffer.position();
            return false;
        }
        int toRead = this.currentCompressedSize + 8;
        if (this.currentByteBufferZipOffset + this.buffer.limit() - this.buffer.position() >= toRead) {
            System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, this.currentByteBufferZipOffset, toRead - this.currentByteBufferZipOffset);
            this.buffer.position(this.buffer.position() + toRead - this.currentByteBufferZipOffset);
            this.unzip(this.currentByteBufferZip, this.currentCompressedSize);
            this.waitUnzipData = false;
            return true;
        }
        System.arraycopy(this.buffer.array(), this.buffer.position(), this.currentByteBufferZip, this.currentByteBufferZipOffset, this.buffer.limit() - this.buffer.position());
        return false;
    }

    private synchronized void _putDate(byte[] data, int offset, int length) throws Exception {
        long bufferRemainingSize = this.buffer.remaining();
        if ((long)(length - offset) >= bufferRemainingSize) {
            this.buffer.put(data, offset, (int)bufferRemainingSize);
            this.buffer.flip();
            while (this._pushToUnzip()) {
            }
            this.buffer.compact();
            this.buffer.clear();
            this._putDate(data, offset += (int)bufferRemainingSize, length);
        } else {
            if (offset == length) {
                return;
            }
            this.buffer.put(data, offset, length - offset);
        }
    }

    @Override
    public <T> void pushData(T t) throws Exception {
        byte[] data = (byte[])t;
        this._putDate(data, 0, data.length);
    }

    @Override
    public void end() throws Exception {
        this.buffer.flip();
        while (this._pushToUnzip()) {
        }
        this._count.await();
        this.logger.debug(UString.format("\u89e3\u538b\u7f29\u5b8c\u6210,\u4e00\u5171\u89e3\u538b {} \u5757\uff0c\u5927\u5c0f {} \uff0c\u89e3\u538b\u540e\u5927\u5c0f {}", this.finished.get(), StringUtility.getDataSize(this.applySize.get()), StringUtility.getDataSize(this.finishedSize.get())));
        if (this.next != null) {
            this.next.end();
        }
        this._threadPool.shutdown();
        this._outputThread.interrupt();
    }

    @Override
    public void close() throws Exception {
        this._threadPool.shutdown();
        this._outputThread.interrupt();
    }
}

