/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.type;

import com.northpool.type.Type;
import com.northpool.type.TypeAny;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeBoolean;
import com.northpool.type.TypeBytes;
import com.northpool.type.TypeDouble;
import com.northpool.type.TypeInteger;
import com.northpool.type.TypeLong;
import com.northpool.type.TypeManager;
import com.northpool.type.TypeNotFindException;
import com.northpool.type.TypeString;
import com.northpool.type.TypeTimestamp;
import com.northpool.type.TypeUnknown;
import com.northpool.type.TypeVoid;
import java.util.Optional;

public interface Types {
    public static final TypeVoid VOID = TypeVoid.INSTANCE;
    public static final TypeUnknown UNKNOWN = TypeUnknown.INSTANCE;
    public static final TypeTimestamp TIME_STAMP = TypeTimestamp.INSTANCE;
    public static final TypeString STRING = TypeString.INSTANCE;
    public static final TypeLong LONG = TypeLong.INSTANCE;
    public static final TypeInteger INTEGER = TypeInteger.INSTANCE;
    public static final TypeDouble DOUBLE = TypeDouble.INSTANCE;
    public static final TypeBigDecimal BIGDECIMAL = TypeBigDecimal.INSTANCE;
    public static final TypeBoolean BOOLEAN = TypeBoolean.INSTANCE;
    public static final TypeBytes BYTES = TypeBytes.INSTANCE;
    public static final Type ANY = TypeAny.INSTANCE;

    public static Type isNumber(Object o) {
        Type type = Types.getType(o);
        if (type.typeIsNumber()) {
            return type;
        }
        return null;
    }

    public static Type getType(Object o) {
        if (o == null) {
            return null;
        }
        Type type = TypeManager.GET_TYPE.getType(o);
        if (type == null) {
            throw new RuntimeException(o.toString() + ",\u7c7b\u578b" + o.getClass().getName() + " \u4e0d\u652f\u6301");
        }
        return type;
    }

    public static Type getTypeByClass(Class<?> clazz) {
        Type type = TypeManager.classTypeMap.get(clazz);
        if (type == null) {
            throw new TypeNotFindException(clazz);
        }
        return type;
    }

    public static Type getTypeByName(String typeName) {
        Optional<Type> optional = TypeManager.typeSet.stream().filter(type -> type.getEnum().name().equalsIgnoreCase(typeName)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public static Class<?> getPrimitiveType(Class<?> wraperClass) {
        return TypeManager.getPrimitiveType(wraperClass);
    }

    public static Class<?> getWraper(Class<?> wraperClass) {
        return TypeManager.getWraper(wraperClass);
    }

    public static boolean isWraper(Class<?> wraperClass) {
        return TypeManager.isWraper(wraperClass);
    }

    public static Object convert(Object value, Class<?> clazz) {
        Type type = Types.getTypeByClass(clazz);
        return type.toType(value);
    }

    public static String valueToString(Object o) {
        if (o == null) {
            return null;
        }
        Type type = Types.getType(o);
        return type.valueToString(o);
    }

    public static enum TYPE_ENUM {
        Integer,
        Timestamp,
        Short,
        Long,
        Float,
        Double,
        Bytes,
        String,
        Boolean,
        Void,
        Geometry,
        BigDecimal,
        Unknown,
        Any,
        VOID,
        Enum;

    }
}

