/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.proj;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class GeometryProject {
    private static Map<String, CoordinateTransform> _transformCache = new HashMap<String, CoordinateTransform>();

    public static Geometry transformGeometry(Geometry geometry, CoordinateTransform transform) {
        if (geometry == null) {
            return null;
        }
        PrecisionModel preci = new PrecisionModel();
        GeometryFactory geometryFactory = new GeometryFactory(preci);
        if (geometry instanceof Point) {
            Coordinate transformed = GeometryProject.transformCoordinate(geometry.getCoordinate(), transform);
            return geometryFactory.createPoint(transformed);
        }
        if (geometry instanceof LineString) {
            Coordinate[] coordinates = geometry.getCoordinates();
            Coordinate[] transformedCoordinates = new Coordinate[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                transformedCoordinates[i] = GeometryProject.transformCoordinate(coordinates[i], transform);
            }
            if ("LinearRing".equals(geometry.getGeometryType())) {
                return geometryFactory.createLinearRing(transformedCoordinates);
            }
            return geometryFactory.createLineString(transformedCoordinates);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            LinearRing shell = (LinearRing)GeometryProject.transformGeometry((Geometry)polygon.getExteriorRing(), transform);
            LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes[i] = (LinearRing)GeometryProject.transformGeometry((Geometry)polygon.getInteriorRingN(i), transform);
            }
            return geometryFactory.createPolygon(shell, holes);
        }
        if (geometry instanceof GeometryCollection) {
            int numGeometries = geometry.getNumGeometries();
            Geometry[] transformedGeometries = new Geometry[numGeometries];
            for (int i = 0; i < numGeometries; ++i) {
                transformedGeometries[i] = GeometryProject.transformGeometry(geometry.getGeometryN(i), transform);
            }
            return geometryFactory.buildGeometry((Collection)Arrays.stream(transformedGeometries).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("Unsupported geometry type: " + geometry.getGeometryType());
    }

    public static String transformWKT(String srcWktGeometry, int fromSrid, int toSrid) {
        try {
            CoordinateTransform transform = GeometryProject.getTransform(fromSrid, toSrid);
            Geometry geometry = new WKTReader().read(srcWktGeometry);
            geometry = GeometryProject.transformGeometry(geometry, transform);
            return geometry.toText();
        }
        catch (Exception ex) {
            throw new RuntimeException("WKT\u51e0\u4f55\u5bf9\u8c61\u6295\u5f71\u8f6c\u6362\u5f02\u5e38", ex);
        }
    }

    public static Coordinate transformCoordinate(Coordinate coordinate, CoordinateTransform transform) {
        ProjCoordinate source = new ProjCoordinate(coordinate.x, coordinate.y);
        ProjCoordinate target = new ProjCoordinate();
        transform.transform(source, target);
        return new Coordinate(target.x, target.y);
    }

    public static String transformBBox(String bbox, int fromSrid, int toSrid) {
        CoordinateTransform transform = GeometryProject.getTransform(fromSrid, toSrid);
        String[] bboxArray = bbox.split(",");
        double[] transformed = new double[4];
        Coordinate minxy = GeometryProject.transformCoordinate(new Coordinate(Double.parseDouble(bboxArray[0]), Double.parseDouble(bboxArray[1])), transform);
        Coordinate maxxy = GeometryProject.transformCoordinate(new Coordinate(Double.parseDouble(bboxArray[2]), Double.parseDouble(bboxArray[3])), transform);
        return minxy.x + "," + minxy.y + "," + maxxy.x + "," + maxxy.y;
    }

    public static CoordinateTransform getTransform(int fromSrid, int toSrid) {
        String sourceCRS = "EPSG:" + fromSrid;
        String targetCRS = "EPSG:" + toSrid;
        String key = sourceCRS + "_" + targetCRS;
        if (_transformCache.containsKey(key)) {
            return _transformCache.get(key);
        }
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem crsSrc = crsFactory.createFromName(sourceCRS);
        CoordinateReferenceSystem crsTarget = crsFactory.createFromName(targetCRS);
        CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
        CoordinateTransform proj = ctFactory.createTransform(crsSrc, crsTarget);
        _transformCache.put(key, proj);
        return proj;
    }
}

