/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.util;

import com.northpool.exception.CommonException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FileUtil {
    public static final int BUFSIZE = 8192;

    public static List<String> getFiles(String dirName) {
        LinkedList<File> list = new LinkedList<File>();
        LinkedList<String> listFileName = new LinkedList<String>();
        File dir = new File(dirName);
        if (!dir.exists()) {
            return new ArrayList<String>();
        }
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isDirectory()) {
                list.add(file[i]);
                continue;
            }
            listFileName.add(file[i].getAbsolutePath());
        }
        while (!list.isEmpty()) {
            File tmp = (File)list.removeFirst();
            if (tmp.isDirectory()) {
                file = tmp.listFiles();
                if (file == null) continue;
                for (int i = 0; i < file.length; ++i) {
                    if (file[i].isDirectory()) {
                        list.add(file[i]);
                        continue;
                    }
                    listFileName.add(file[i].getAbsolutePath());
                }
                continue;
            }
            listFileName.add(tmp.getAbsolutePath());
        }
        return listFileName;
    }

    public static void newFolder(String folderPath) {
        try {
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void newFile(String filePathAndName, String fileContent) {
        OutputStreamWriter resultFile = null;
        PrintWriter myFile = null;
        try {
            String filePath = filePathAndName;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            if (!myFilePath.exists()) {
                myFilePath.createNewFile();
            }
            resultFile = new FileWriter(myFilePath);
            myFile = new PrintWriter(resultFile);
            String strContent = fileContent;
            myFile.println(strContent);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            myFile.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean createFile(String filePathAndName, String fileContent) {
        File filePath = new File(filePathAndName);
        if (!filePath.exists()) {
            try {
                filePath.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            outputStream.write(fileContent.getBytes());
            outputStream.flush();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void delFile(String filePathAndName) {
        try {
            Path path = Paths.get(filePathAndName, new String[0]);
            Files.delete(path);
        }
        catch (NoSuchFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void delFolder(String folderPath) {
        try {
            FileUtil.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static void delAllFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delAllFile(path + "/" + tempList[i]);
            FileUtil.delFolder(path + "/" + tempList[i]);
        }
    }

    public static void copyFile(String oldPath, String newPath) {
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                inStream = new FileInputStream(oldPath);
                fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = inStream.read(buffer)) != -1) {
                    fs.write(buffer, 0, byteread);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void copyFolder(String oldPath, String newPath) {
        try {
            FileUtil.copyFolder(oldPath, newPath, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFolder(String oldPath, String newPath, Boolean overwrite) throws IOException {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    String newFileName = newPath + File.separator + temp.getName().toString();
                    File newFile = new File(newFileName);
                    if (newFile.exists()) {
                        if (overwrite.booleanValue()) {
                            newFile.delete();
                            com.google.common.io.Files.copy((File)temp, (File)newFile);
                        }
                    } else {
                        com.google.common.io.Files.copy((File)temp, (File)newFile);
                    }
                }
                if (!temp.isDirectory()) continue;
                FileUtil.copyFolder(oldPath + File.separator + file[i], newPath + File.separator + file[i], overwrite);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static void copyFile(String oldPath, String newPath, Boolean overwrite) {
        InputStream inStream = null;
        FileOutputStream fs = null;
        try {
            int byteread = 0;
            File oldfile = new File(oldPath);
            File newfile = null;
            if (!oldfile.exists()) {
                return;
            }
            if (!overwrite.booleanValue() && (newfile = new File(newPath)).exists()) {
                return;
            }
            inStream = new FileInputStream(oldPath);
            fs = new FileOutputStream(newPath);
            byte[] buffer = new byte[1444];
            while ((byteread = inStream.read(buffer)) != -1) {
                fs.write(buffer, 0, byteread);
            }
            fs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fs.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void moveFile(String oldPath, String newPath) {
        FileUtil.copyFile(oldPath, newPath);
        FileUtil.delFile(oldPath);
    }

    public static void moveFolder(String oldPath, String newPath) throws IOException {
        FileUtil.copyFolder(oldPath, newPath);
        FileUtil.delFolder(oldPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(String outFile, String[] files, String extend) {
        FileChannel outChannel = null;
        try {
            outChannel = new FileOutputStream(outFile, true).getChannel();
            for (String f : files) {
                FileChannel fc = new FileInputStream(f).getChannel();
                ByteBuffer bb = ByteBuffer.allocate(8192);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    outChannel.write(bb);
                    bb.clear();
                }
                outChannel.write(ByteBuffer.wrap(extend.getBytes()));
                fc.close();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static OutputStream getOutputStream(String path, Boolean getNewOne) throws CommonException, IOException {
        File file = new File(path);
        if (getNewOne.booleanValue()) {
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new CommonException("\u8def\u5f84" + path + "\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u6587\u4ef6");
                }
                FileUtil.delFile(path);
            } else {
                file.createNewFile();
            }
            return new FileOutputStream(path);
        }
        if (file.exists()) {
            if (!file.isFile()) {
                throw new CommonException("\u8def\u5f84" + path + "\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u6587\u4ef6");
            }
        } else {
            file.createNewFile();
        }
        return new FileOutputStream(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] File2byte(String filePath) {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer;
    }

    public static void byte2File(byte[] buf, String fileName) {
        Path path = Paths.get(fileName, new String[0]);
        FileUtil.byte2File(buf, path.getParent().toString(), path.getFileName().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void byte2File(byte[] buf, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            file = new File(filePath + File.separator + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] a) throws IOException {
        String f = "C:\\transtest\\create_file_dir\\complete\\\u6d4b\u8bd5\u5168\u91cf\u534f\u8baeaction1\\";
        String t = "C:\\transtest\\send_file_dir\\complete\\\u6d4b\u8bd5\u5168\u91cf\u534f\u8baeaction1\\";
        FileUtil.copyFolder(f, t);
    }
}

