/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.reflect.beanHolder.FieldHoder;

import com.northpool.commons.reflect.BeanHolder;
import com.northpool.commons.reflect.FieldHolder;
import com.northpool.commons.reflect.Invoker;
import com.northpool.commons.reflect.Reflect;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFieldHolderImpl<T>
implements FieldHolder {
    protected BeanHolder<T> beanHolder;
    protected Map<Class<?>, Annotation> annotationMap = new HashMap();
    protected String fieldName;
    protected Invoker readerInvoker;
    protected Invoker writeInvoker;
    protected Field field;
    protected Class<?> fieldType;
    protected int natureType;
    protected int classType;

    public AbstractFieldHolderImpl(final Field field, Class<T> clazz, BeanHolder<T> beanHolder) {
        Annotation[] annotations;
        this.fieldName = field.getName();
        this.classType = 0;
        this.natureType = 0;
        this.field = field;
        this.field.setAccessible(true);
        this.fieldType = field.getType();
        for (Annotation annotation : annotations = this.field.getAnnotations()) {
            this.annotationMap.put(annotation.annotationType(), annotation);
        }
        this.readerInvoker = new Invoker(){

            @Override
            public Method method() {
                return null;
            }

            @Override
            public Object invoke(Object host, Object[] args) {
                try {
                    return field.get(host);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.writeInvoker = new Invoker(){

            @Override
            public Method method() {
                return null;
            }

            @Override
            public Object invoke(Object host, Object[] args) {
                try {
                    field.set(host, args[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        };
    }

    public AbstractFieldHolderImpl(PropertyDescriptor p, Class<T> clazz, BeanHolder<T> beanHolder) {
        this.fieldName = p.getName();
        Field f = this.getFieldByName(clazz, false);
        if (f == null) {
            this.classType = 1;
            f = this.getFieldByName(clazz.getSuperclass(), true);
        } else {
            this.classType = 0;
        }
        this.natureType = f == null ? 1 : 0;
        if (this.natureType == 0) {
            Method writeMethod;
            Annotation[] annotations;
            this.field = f;
            this.fieldType = f.getType();
            for (Annotation annotation : annotations = this.field.getAnnotations()) {
                this.annotationMap.put(annotation.annotationType(), annotation);
            }
            Method readMethod = p.getReadMethod();
            if (readMethod != null) {
                readMethod.setAccessible(true);
                this.readerInvoker = Reflect.getInvokerManager().newInvoker(readMethod);
            }
            if ((writeMethod = p.getWriteMethod()) != null) {
                writeMethod.setAccessible(true);
                this.writeInvoker = Reflect.getInvokerManager().newInvoker(writeMethod);
            }
        } else {
            Method writeMethod;
            Method readMethod = p.getReadMethod();
            if (readMethod != null) {
                readMethod.setAccessible(true);
                this.readerInvoker = Reflect.getInvokerManager().newInvoker(readMethod);
            }
            if ((writeMethod = p.getWriteMethod()) != null) {
                writeMethod.setAccessible(true);
                this.writeInvoker = Reflect.getInvokerManager().newInvoker(writeMethod);
            }
        }
    }

    protected Field getFieldByName(Class<?> clazz, Boolean findParent) {
        Field f;
        block4: {
            f = null;
            if (clazz == null) {
                return null;
            }
            try {
                f = clazz.getDeclaredField(this.fieldName);
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw e;
            }
            catch (NoSuchFieldException e) {
                if (!findParent.booleanValue()) break block4;
                f = this.getFieldByName(clazz.getSuperclass(), findParent);
            }
        }
        return f;
    }

    public Map<Class<?>, Annotation> getAnnotations() {
        return this.annotationMap;
    }

    @Override
    public BeanHolder<?> getBeanHolder() {
        return this.beanHolder;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Invoker getReaderInvoker() {
        return this.readerInvoker;
    }

    @Override
    public Invoker getWriteInvoker() {
        return this.writeInvoker;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotationMap.get(annotationClass);
    }

    @Override
    public Class<?> getFieldType() {
        return this.fieldType;
    }

    @Override
    public Boolean isAbstract() {
        if (this.natureType == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void setValue(Object o, Object value) throws Exception {
        Invoker invoker = this.getWriteInvoker();
        if (invoker == null) {
            throw new Exception("\u5b57\u6bb5" + this.fieldName + "\u4e0d\u652f\u6301\u5199\u5165\u65b9\u6cd5");
        }
        invoker.invoke(o, new Object[]{value});
    }

    @Override
    public Object getValue(Object o) throws Exception {
        Invoker invoker = this.getReaderInvoker();
        if (invoker == null) {
            throw new Exception("\u5b57\u6bb5" + this.fieldName + "\u4e0d\u652f\u6301\u8bfb\u53d6\u65b9\u6cd5");
        }
        return invoker.invoke(o, null);
    }
}

