/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.grid;

import com.northpool.commons.util.PackageUtil;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.spatial.grid.impl.GridName;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class GridManager {
    private static HashMap<String, QuadtreeGrid> QUADTREE_MAP;
    private static String SCAN_PACKAGE;

    public static QuadtreeGrid getQuadtreeGrid(Constants.GRID_UNIT unit, Constants.GRID_BASE base, Constants.GRID_TYPE type) {
        String gridBeanName = type.name() + "_" + unit.name() + "_" + base.name();
        QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
        if (grid == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a" + gridBeanName);
        }
        return grid;
    }

    public static QuadtreeGrid getQuadtreeGrid(Constants.GRID_UNIT unit, Constants.GRID_BASE base, Constants.GRID_TYPE type, int[] origin, double[] resolutions) {
        String gridBeanName = type.name() + "_" + unit.name() + "_" + base.name();
        if (origin != null && resolutions != null) {
            QuadtreeGrid grid = GridManager.getQuadtreeGrid(gridBeanName, origin, resolutions);
            return grid;
        }
        QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
        if (grid == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a" + gridBeanName);
        }
        return grid;
    }

    public static QuadtreeGrid getQuadtreeGrid(String gridBeanName) {
        QuadtreeGrid grid = QUADTREE_MAP.get(gridBeanName);
        if (grid == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a" + gridBeanName);
        }
        return grid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QuadtreeGrid getQuadtreeGrid(String gridBeanName, int[] origin, double[] resolutions) {
        if (origin == null && resolutions == null) {
            return GridManager.getQuadtreeGrid(gridBeanName);
        }
        int minX = origin[0];
        int maxY = origin[1];
        String key = GridManager.getGridKey(gridBeanName, origin, resolutions);
        QuadtreeGrid grid = null;
        grid = QUADTREE_MAP.get(key);
        if (grid == null) {
            grid = QUADTREE_MAP.get(gridBeanName);
            if (grid == null) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a" + gridBeanName);
            }
            try {
                grid = (QuadtreeGrid)grid.getClass().newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            grid.setMinX(minX);
            grid.setMaxY(maxY);
            grid.setResolutions(resolutions);
            HashMap<String, QuadtreeGrid> hashMap = QUADTREE_MAP;
            synchronized (hashMap) {
                QUADTREE_MAP.put(key, grid);
            }
        }
        return grid;
    }

    public static String getGridKey(String gridBeanName, int[] origin, double[] resolutions) {
        int minX = origin[0];
        int maxY = origin[1];
        StringBuilder keyBuilder = new StringBuilder(gridBeanName);
        keyBuilder.append("_");
        keyBuilder.append(minX);
        keyBuilder.append("_");
        keyBuilder.append(maxY);
        keyBuilder.append("_");
        keyBuilder.append(StringUtils.join((Object[])new Serializable[]{resolutions, ","}));
        String key = keyBuilder.toString();
        return key;
    }

    public static void main(String[] aaa) {
        QuadtreeGrid grid = GridManager.getQuadtreeGrid(Constants.GRID_UNIT.degree, Constants.GRID_BASE.base512, Constants.GRID_TYPE.esri);
        System.out.print(grid.getExtent(3, 3, 0).getWkt());
    }

    static {
        SCAN_PACKAGE = "com.northpool.spatial.grid.impl.quadtreegrid";
        QUADTREE_MAP = new HashMap();
        Set<Class<?>> gridClassSet = null;
        try {
            gridClassSet = PackageUtil.findClassAnnotation(SCAN_PACKAGE, GridName.class);
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        gridClassSet.forEach(gridClass -> {
            try {
                GridName gridName = gridClass.getAnnotation(GridName.class);
                String name = gridName.name();
                QuadtreeGrid grid = (QuadtreeGrid)gridClass.newInstance();
                QUADTREE_MAP.put(name, grid);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
    }
}

