/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.commons.classloader;

import com.northpool.commons.classloader.MemoryClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MemoryJar {
    protected String name;
    protected HashMap<String, ByteBuffer> resourceMap = new HashMap();

    public MemoryJar(String name, byte[] bytes) throws IOException {
        this.name = name;
        this.init(name, bytes);
    }

    public String getName() {
        return this.name;
    }

    protected ByteBuffer createBuffer(byte[] byte_s_) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(byte_s_.length);
        buffer.put(byte_s_);
        return buffer;
    }

    protected void init(String jarName, byte[] jarByte) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(jarByte));
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            String fileName_zip = entry.getName();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byte_s = new byte[1024];
            int num = -1;
            while ((num = zis.read(byte_s, 0, byte_s.length)) > -1) {
                byteArrayOutputStream.write(byte_s, 0, num);
            }
            byte[] byte_s_ = byteArrayOutputStream.toByteArray();
            String resourceUrl = MemoryClassLoader.createURIPath(fileName_zip);
            ByteBuffer buffer = this.createBuffer(byte_s_);
            this.resourceMap.put(resourceUrl, buffer);
            byteArrayOutputStream.close();
        }
        zis.close();
    }

    public HashMap<String, ByteBuffer> getAllResources() {
        return this.resourceMap;
    }
}

