/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources;

import com.mongodb.event.ConnectionCheckOutFailedEvent;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoConnectionPoolMonitor
implements ConnectionPoolListener {
    private static Logger Log = LoggerFactory.getLogger((String)"MongoConnectionPoolMonitor");
    public static Map<String, MongoConnectionPoolMonitor> Cache = new ConcurrentHashMap<String, MongoConnectionPoolMonitor>();
    private String url;
    private AtomicInteger nCreated;
    private AtomicInteger nClosed;
    private AtomicInteger nAcquired;
    private AtomicInteger nAcquireFailed;
    private AtomicInteger nReturned;

    public MongoConnectionPoolMonitor(String uri) {
        this.url = uri;
        if (!Cache.containsKey(uri)) {
            Cache.put(uri, this);
        }
        this.nCreated = new AtomicInteger(0);
        this.nClosed = new AtomicInteger(0);
        this.nAcquired = new AtomicInteger(0);
        this.nAcquireFailed = new AtomicInteger(0);
        this.nReturned = new AtomicInteger(0);
    }

    public void connectionPoolCreated(ConnectionPoolCreatedEvent event) {
        Log.info(event.toString());
    }

    public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
        Log.info(event.toString());
    }

    public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
        this.nAcquired.incrementAndGet();
    }

    public void connectionCheckOutFailed(ConnectionCheckOutFailedEvent event) {
        this.nAcquireFailed.incrementAndGet();
    }

    public void connectionCheckedIn(ConnectionCheckedInEvent event) {
        this.nReturned.incrementAndGet();
    }

    public void connectionCreated(ConnectionCreatedEvent event) {
        this.nCreated.incrementAndGet();
    }

    public void connectionClosed(ConnectionClosedEvent event) {
        this.nClosed.incrementAndGet();
    }

    public AtomicInteger getnCreated() {
        return this.nCreated;
    }

    public AtomicInteger getnClosed() {
        return this.nClosed;
    }

    public AtomicInteger getnAcquired() {
        return this.nAcquired;
    }

    public AtomicInteger getnAcquireFailed() {
        return this.nAcquireFailed;
    }

    public AtomicInteger getnReturned() {
        return this.nReturned;
    }
}

