/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.scroll;

import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileRangeScroll
implements ITileScroll {
    private static Logger logger = LoggerFactory.getLogger(TileRangeScroll.class);
    protected boolean init = false;
    private int beginX;
    private int endX;
    private int beginY;
    private int endY;
    private IGridSystem grid;
    private int currentX;
    private int currentY;
    private int level;
    private String bbox;

    public TileRangeScroll(int level, String bbox, IGridSystem grid) {
        this.grid = grid;
        this.currentX = this.beginX;
        this.currentY = this.beginY;
        this.level = level;
        this.bbox = bbox;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        double beginResolution = this.grid.getResolution(this.level);
        if (this.bbox != null) {
            String[] boxs = this.bbox.split(",");
            double left = Double.valueOf(boxs[0]);
            double bottom = Double.valueOf(boxs[1]);
            double right = Double.valueOf(boxs[2]);
            double top = Double.valueOf(boxs[3]);
            this.beginX = (int)this.grid.calculateX(beginResolution, left);
            this.beginY = (int)this.grid.calculateY(beginResolution, top);
            this.endX = (int)Math.ceil(this.grid.calculateX(beginResolution, right));
            this.endY = (int)Math.ceil(this.grid.calculateY(beginResolution, bottom));
            this.currentX = this.beginX;
            this.currentY = this.beginY;
        } else {
            this.beginX = (int)this.grid.calculateX(beginResolution, this.grid.getMinX());
            this.beginY = (int)this.grid.calculateY(beginResolution, this.grid.getMaxY());
            this.endX = (int)Math.ceil(this.grid.calculateX(beginResolution, this.grid.getMaxX()));
            this.endY = (int)Math.ceil(this.grid.calculateY(beginResolution, this.grid.getMinY()));
        }
        this.init = true;
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u6839\u636e\u6570\u636e\u8303\u56f4\uff1a[{}]\uff0c\u8ba1\u7b97\u5f97\u51fa\u74e6\u7247\u7f16\u53f7\u8303\u56f4\uff1aZ:{}, X:[{}~{}], Y:[{}~{}]", new Object[]{this.bbox, this.level, this.beginX, this.endX, this.beginY, this.endY});
        }
    }

    public synchronized boolean hasNext(boolean loged, Map<String, Integer> batchSize) {
        return this.currentX < this.endX && this.currentY < this.endY;
    }

    @Override
    public boolean hasNext() {
        return this.currentX < this.endX && this.currentY < this.endY;
    }

    @Override
    public synchronized TileLayout next() {
        GridExtent gridExtent = this.grid.getExtent(this.level, this.currentX, this.currentY);
        ++this.currentX;
        if (this.currentX >= this.endX) {
            this.goNextRow();
        }
        TileLayout layout = new TileLayout(gridExtent, null);
        return layout;
    }

    private synchronized void goNextRow() {
        this.currentX = this.beginX;
        ++this.currentY;
    }

    @Override
    public Long getCount() {
        return ((long)this.endY - (long)this.beginY) * ((long)this.endX - (long)this.beginX);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void release() {
    }
}

