/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.abstractclass;

import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.service.manager.task.exception.TaskCancelException;
import com.northpool.service.manager.task.log.ITaskLogger;
import com.northpool.tiledispatch.base.AbstractBaseComponent;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.handler.ITileHandlerStream;
import com.northpool.tiledispatch.consumer.handler.TileListCutHandler;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import com.northpool.tiledispatch.exception.ConsumeException;
import com.northpool.tiledispatch.exception.TileCutConsumeException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTileConsumer
extends AbstractBaseComponent
implements ITileConsumer {
    private static Logger logger = LoggerFactory.getLogger(AbstractTileConsumer.class);
    protected ITileHandlerStream handler;
    protected ScheduledExecutorService logPool;
    protected ITileScroll scroll;

    public AbstractTileConsumer(ITileScroll scroll, ITileHandlerStream handler) {
        this.handler = handler;
        this.scroll = scroll;
    }

    @Override
    public void consume() throws ConsumeException {
        this.scroll.init();
        CountDownLatch count = new CountDownLatch(this.scroll.getCount().intValue());
        int nTotal = this.scroll.getCount().intValue();
        this.handler.setCount(count);
        ScheduledFuture<?> future = null;
        int nPercent10 = nTotal > 10 ? nTotal / 10 : 1;
        AtomicLong nFinished = new AtomicLong(0L);
        AtomicLong nRealTiles = new AtomicLong(0L);
        AtomicLong lastPct = new AtomicLong(0L);
        int currentLevel = this.scroll.getLevel();
        this.handler.setProgressHandler(num -> {
            long currNum = nFinished.incrementAndGet();
            if (num > 0) {
                nRealTiles.incrementAndGet();
            }
            if (nPercent10 > 1 && 0L == currNum % (long)nPercent10) {
                logger.info(Log4jUtil.MARKER_DIAG, "==>\u7b2c{}\u7ea7\u8d77\u59cb\u7684\u74e6\u7247\u9884\u70ed\u5b50\u4efb\u52a1\u5927\u7ea6\u8fdb\u5ea6\uff1a{}%", (Object)currentLevel, (Object)(currNum * 100L / (long)nTotal));
            }
        });
        try {
            future = this.logPool.scheduleWithFixedDelay(() -> {
                if (this.error) {
                    this.logPool.shutdown();
                    return;
                }
                long finishNum = (long)nTotal - count.getCount();
                if (nPercent10 > 1 && finishNum / (long)nPercent10 > lastPct.get()) {
                    lastPct.updateAndGet(oldVal -> finishNum / (long)nPercent10);
                    String logMsg = "\u6b63\u5728\u751f\u4ea7\u7b2c" + currentLevel + "\u7ea7\u5f00\u59cb\u7684\u4e00\u7ec4\u74e6\u7247\uff0c\u8fdb\u5ea6\uff1a" + finishNum + "/" + nTotal + " \uff08" + finishNum * 100L / (long)nTotal + "%\uff09";
                    this.log(logMsg);
                }
            }, 2L, 60L, TimeUnit.SECONDS);
            int index = 0;
            while (this.scroll.hasNext()) {
                TileLayout layout = this.scroll.next();
                if (layout != null) {
                    this.handler.handle(layout);
                }
                ++index;
                if (!this.isCancel()) continue;
                throw new TaskCancelException("\u4efb\u52a1\u5728\u7b2c " + this.scroll.getLevel() + " \u7ea7\u74e6\u7247\u751f\u4ea7\u9636\u6bb5\u88ab\u53d6\u6d88");
            }
            int deviation = nTotal - index;
            for (int i = 0; i < deviation; ++i) {
                count.countDown();
            }
            count.await();
            if (this.handler.isError()) {
                throw new TileCutConsumeException(this.handler.getException().getMessage(), this.handler.getException());
            }
            if (this.cancel) {
                throw new TaskCancelException("\u4efb\u52a1\u5728\u7b2c " + this.scroll.getLevel() + " \u7ea7\u74e6\u7247\u751f\u4ea7\u9636\u6bb5\u88ab\u53d6\u6d88");
            }
            long nRealCount = nRealTiles.get();
            if (Log4jUtil.isDiagnoseEnable()) {
                logger.info(Log4jUtil.MARKER_DIAG, "==> {} \u7ea7\u5904\u7406\u4e86 {} / {} \u4e2a\u7f51\u683c", new Object[]{currentLevel, nRealCount, nTotal});
                if (this.handler instanceof TileListCutHandler) {
                    ((TileListCutHandler)this.handler).summarize();
                }
            }
        }
        catch (Exception e) {
            throw new TileCutConsumeException(e);
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
            this.release();
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.handler.cancel();
    }

    @Override
    public void setLogger(ITaskLogger cutLogger) {
        this.cutLogger = cutLogger;
    }

    @Override
    public void setLogPool(ScheduledExecutorService logPool) {
        this.logPool = logPool;
    }
}

