/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.buffer;

import com.northpool.gis.vector_cut.screenloction.utils.GeometryUtils;
import com.northpool.gis.vector_cut.screenloction.writer.ConcurrentFeatureDoubleWriter;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.Extent;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.buffer.IDataBuffer;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.locationtech.jts.geom.Geometry;

public class FeatureWriterBuffer
implements IDataBuffer<Object[]> {
    Map<String, ConcurrentFeatureDoubleWriter> tileMap = new ConcurrentHashMap<String, ConcurrentFeatureDoubleWriter>();
    Map<Long, Deque<Object[]>> itemThreadBuffer = new ConcurrentHashMap<Long, Deque<Object[]>>(Runtime.getRuntime().availableProcessors() * 2);
    ITileSaver saver;
    IDocumentEncoder encoder;
    IGridSystem grid;
    protected Throwable e;
    boolean isInit = false;
    public boolean error = false;
    protected ExecutorService saveThread;
    protected ScheduledExecutorService collectThread;
    public static final int MAX_COORDINATES_SIZE_THRESHOLD = 30720;
    public static final int MAX_UN_MODIFIED_NUM = 3;
    public static final int MAX_UN_FLUSH_NUM = 10;

    public FeatureWriterBuffer(ITileSaver tileSaver, IDocumentEncoder encoder, IGridSystem grid) {
        this.saver = tileSaver;
        this.encoder = encoder;
        this.grid = grid;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver.init();
        this.saveThread = TileDispatchTaskManager.getInstance().getNewExecutor();
        this.collectThread = Executors.newScheduledThreadPool(1);
        this.collectThread.scheduleWithFixedDelay(() -> this.collect(), 2L, 60L, TimeUnit.SECONDS);
    }

    private synchronized void collect() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator<Long> iterator = this.itemThreadBuffer.keySet().iterator();
        while (iterator.hasNext()) {
            Deque<Object[]> deque = this.itemThreadBuffer.get(iterator.next());
            Object[] item = null;
            while ((item = deque.poll()) != null) {
                list.add(item);
            }
        }
        this.merge(list);
    }

    private void merge(List<Object[]> datas) {
        for (Object[] data : datas) {
            String extentKey = (String)data[0];
            ConcurrentFeatureDoubleWriter writer = this.getWriter(extentKey);
            Object[] item = (Object[])data[1];
            Geometry geom = (Geometry)data[2];
            Object area = data[3];
            Object standardArea = null;
            if (data.length > 4) {
                standardArea = data[4];
            }
            StringBuilder sb = null;
            sb = standardArea != null ? writer.createPropertysPart(Constants.GEO_TYPE.valueOf((String)geom.getGeometryType().toUpperCase()), null, item, new Object[]{area, standardArea}) : writer.createPropertysPart(Constants.GEO_TYPE.valueOf((String)geom.getGeometryType().toUpperCase()), null, item, new Object[]{area});
            writer.addGeometry(geom);
            writer.setPropertysPart((Object)sb);
            double bboxArea = geom.getEnvelopeInternal().getArea();
            writer.substractArea(bboxArea);
        }
    }

    @Override
    public void push(List<Object[]> datas) {
        if (this.error) {
            throw new RuntimeException(this.e);
        }
        long threadId = Thread.currentThread().getId();
        Deque<Object[]> deque = this.itemThreadBuffer.get(threadId);
        if (deque == null) {
            deque = new ConcurrentLinkedDeque<Object[]>();
            Deque<Object[]> newDeque = this.itemThreadBuffer.putIfAbsent(threadId, deque);
            if (newDeque != null) {
                deque = newDeque;
            }
        }
        deque.addAll(datas);
    }

    @Override
    public synchronized void flush() {
        try {
            Set<Map.Entry<String, ConcurrentFeatureDoubleWriter>> collect = this.tileMap.entrySet();
            HashMap<String, ConcurrentFeatureDoubleWriter> writerMap = new HashMap<String, ConcurrentFeatureDoubleWriter>(collect.size());
            for (Map.Entry entry : collect) {
                String key = (String)entry.getKey();
                ConcurrentFeatureDoubleWriter writer = (ConcurrentFeatureDoubleWriter)entry.getValue();
                int coordinatesSize = writer.getCoordinatesSize();
                if (writer.getArea() < 0.0) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (coordinatesSize > 30720) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (writer.getUnModifiedNum() > 2 && coordinatesSize == writer.getLastSize()) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (writer.getUnFlushNum() > 10) {
                    writerMap.put(key, writer);
                    this.tileMap.remove(key);
                    continue;
                }
                if (coordinatesSize == writer.getLastSize()) {
                    writer.setUnModifiedNum(writer.getUnModifiedNum() + 1);
                } else {
                    writer.setLastSize(coordinatesSize);
                    writer.setUnModifiedNum(0);
                }
                writer.setUnFlushNum(writer.getUnFlushNum() + 1);
            }
            this.saveThread.execute(() -> this.saveWriterMap(writerMap));
        }
        catch (Exception e) {
            this.e = e;
            this.error = true;
        }
    }

    @Override
    public synchronized void flushAll() {
        this.collectThread.shutdown();
        try {
            this.collectThread.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.collect();
        this.saveWriterMap(this.tileMap);
    }

    private void saveWriterMap(Map<String, ConcurrentFeatureDoubleWriter> writerMap) {
        ArrayList<Object[]> saveList = new ArrayList<Object[]>(writerMap.size());
        for (String key : writerMap.keySet()) {
            ConcurrentFeatureDoubleWriter writer = writerMap.get(key);
            byte[] data = writer.getData();
            saveList.add(new Object[]{key, data});
            writer.clear();
        }
        try {
            long start = System.currentTimeMillis();
            System.out.println("update time:" + (System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            this.saver.save(saveList, this.encoder);
            System.out.println("insert time:" + (System.currentTimeMillis() - start));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ConcurrentFeatureDoubleWriter getWriter(String extentKey) {
        ConcurrentFeatureDoubleWriter writer = this.tileMap.get(extentKey);
        if (writer == null) {
            writer = new ConcurrentFeatureDoubleWriter();
            String[] splits = extentKey.split("_");
            GridExtent extent = this.grid.getGridExtent(Integer.valueOf(splits[0]).intValue(), Integer.valueOf(splits[1]).intValue(), Integer.valueOf(splits[2]).intValue());
            Geometry geometryByExtent = this.getGeometryByExtent(extent);
            double area = geometryByExtent.getEnvelopeInternal().getArea();
            writer.setArea(area);
            ConcurrentFeatureDoubleWriter newWriter = this.tileMap.putIfAbsent(extentKey, writer);
            if (newWriter != null) {
                writer = newWriter;
            }
        }
        return writer;
    }

    private Geometry getGeometryByExtent(GridExtent extent) {
        double[] points = GeometryUtils.getDoubleArrayFromExtent4Point((Extent.Extent4Point)extent.getBBoxCoordinates());
        return GeometryUtils.getPolygonFromPoints((double[])points);
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.saveThread.shutdown();
        this.saveThread.awaitTermination(timeout, unit);
    }
}

