/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task;

import com.northpool.exception.Message;
import com.northpool.gis.vector_cut.screenloction.cell.AreaUnionCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.layout.LayerTilePrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.resources.MongodbDao;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoShell;
import com.northpool.service.config.data_service.tileInfo.IAreaTileInfo;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.VectorCutMongoConsumer;
import com.northpool.tiledispatch.consumer.handler.TileDataCutHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.AreaStatisTileDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.GridExtentDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.producer.ITileProducer;
import com.northpool.tiledispatch.producer.TileLayoutProducer;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.stage.TileProduceStage;
import com.northpool.tiledispatch.task.stage.abstractclass.AbstractTaskStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import org.apache.commons.lang3.StringUtils;

public class AreaUnionCutTask
extends AbstractTileDispatchTask {
    ILayer layer;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;

    public AreaUnionCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel) {
        super(name);
        this.layer = layer;
        this.grid = grid;
        this.beginLevel = beginLevel;
        this.mongodbDataSource = dataSource;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        IDataService dataService = this.getDataService();
        this.bbox = StringUtils.isNotBlank((CharSequence)((DataServiceBean)dataService.getBean()).getBbox()) ? ((DataServiceBean)dataService.getBean()).getBbox() : this.bbox;
        this.buildStages();
        Client client = dataService.getClient();
        IAreaTileInfo areaTileInfo = this.createAreaTileInfo(dataService);
        dataService.addAreaTileInfo(areaTileInfo);
        try {
            client.getDataServiceManager().update((Object)dataService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildStages() {
        IDataService dataService = this.getDataService();
        IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
        if (featureTileInfo == null) {
            throw new Message(dataService.getName() + " \u6570\u636e\u670d\u52a1\u7f3a\u5c11featureTile\u4fe1\u606f");
        }
        AbstractTaskStage stage = null;
        int beginLevel = this.beginLevel;
        int endLevel = featureTileInfo.getLevel();
        String produceStageName = "\u751f\u4ea7" + this.grid.getBeginLevel() + "\u81f3" + endLevel + "\u7ea7\u522b\u74e6\u7247\u6846\u67b6";
        LayerTilePrecutter cell = new LayerTilePrecutter(this.layer);
        ITileProducer producer = this.createProducer(beginLevel, endLevel, (ITileLayoutPrecutter)cell);
        cell.setMainLevel(Integer.valueOf(endLevel));
        stage = new TileProduceStage(produceStageName, producer, beginLevel, endLevel);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
        boolean hasAreaField = featureTileInfo.getAreaField() != null;
        ITileConsumer tileConsumer = this.createCaculateConsumer(endLevel, hasAreaField);
        String consumeStageName = "\u751f\u4ea7" + endLevel + "\u7ea7\u522b\u7edf\u8ba1\u74e6\u7247";
        stage = new TileConsumeStage(consumeStageName, tileConsumer);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
        for (int i = endLevel - 1; i >= beginLevel; --i) {
            tileConsumer = this.createMergeConsumer(i, i + 1);
            consumeStageName = "\u751f\u4ea7" + i + "\u7ea7\u522b\u7edf\u8ba1\u74e6\u7247";
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
        }
    }

    private ITileProducer createProducer(int start, int end, ITileLayoutPrecutter cell) {
        Integer gridBeginLevel = this.grid.getUnit().equals((Object)Constants.GRID_UNIT.degree) ? this.grid.getBeginLevel() + 1 : this.grid.getBeginLevel();
        TileLayoutProducer tileProducer = new TileLayoutProducer(cell, this.saver, this.executor, gridBeginLevel, end, this.grid, this.bbox, this.layer.getId(), new GridExtentDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private ITileConsumer createCaculateConsumer(int level, boolean hasAreaField) {
        AreaUnionCutterCell cutterCell = new AreaUnionCutterCell(this.layer, this.getFeatureSaver().getMongoDao(), Integer.valueOf(level), hasAreaField);
        TileDataCutHandler handlerStream = new TileDataCutHandler(this.executor, 1, (ITileCutterCell<GridExtent, Object[]>)cutterCell, this.saver, new AreaStatisTileDocumentEncoder());
        handlerStream.setResume(this.resume);
        TileLayoutScroll scroll = new TileLayoutScroll(level, this.grid, this.saver, null, true);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileConsumer createMergeConsumer(int level, int parentLevel) {
        AreaUnionCutterCell cutterCell = new AreaUnionCutterCell(this.layer, this.saver.getMongoDao(), Integer.valueOf(parentLevel), false);
        TileDataCutHandler handlerStream = new TileDataCutHandler(this.executor, 1, (ITileCutterCell<GridExtent, Object[]>)cutterCell, this.saver, new AreaStatisTileDocumentEncoder());
        handlerStream.setResume(this.resume);
        TileLayoutScroll scroll = new TileLayoutScroll(level, this.grid, this.saver, null, true);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private MongoTileSaver createTileSaver() {
        IAreaTileInfo storageInfo;
        IDataService dataService = this.getDataService();
        if (!this.resume && (storageInfo = dataService.getAreaTileInfo()) != null) {
            storageInfo.drop();
        }
        String storageName = dataService.getAreaStorageName();
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        MongodbDao mongoDao = tileSaver.getMongoDao();
        mongoDao.createIndex(new String[]{MongoTileSaver.fkey});
        return tileSaver;
    }

    private MongoTileSaver getFeatureSaver() {
        IDataService dataService = this.getDataService();
        String storageName = dataService.getFeatureStorageName();
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        return tileSaver;
    }

    private IAreaTileInfo createAreaTileInfo(IDataService dataService) {
        IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(featureTileInfo.getLevel());
        storageInfoBean.setStorageName(dataService.getAreaStorageName());
        storageInfoBean.setCompleted(false);
        AreaTileInfoBean areaTileInfoBean = new AreaTileInfoBean();
        areaTileInfoBean.setStorageInfo(storageInfoBean);
        areaTileInfoBean.setGroupFields(featureTileInfo.getGroupFields());
        return new AreaTileInfoShell(dataService.getClient(), areaTileInfoBean);
    }

    @Override
    public void success() throws Exception {
        IDataService dataService = this.getDataService();
        Client client = dataService.getClient();
        IAreaTileInfo areaTileInfo = dataService.getAreaTileInfo();
        if (areaTileInfo != null) {
            IStorageInfo storageInfo = areaTileInfo.getStorageInfo();
            storageInfo.setCompleted(true);
            try {
                client.getDataServiceManager().update((Object)dataService);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.success();
    }

    private IDataService getDataService() {
        return ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
    }
}

