/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task;

import com.northpool.exception.Message;
import com.northpool.gis.vector_cut.screenloction.cell.AreaStatisCell;
import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.MongodbDao;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoShell;
import com.northpool.service.config.data_service.tileInfo.IAreaTileInfo;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.handler.FeatureAreaHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.AreaStatisTileDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.GridExtentDocumentEncoder;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.producer.ITileProducer;
import com.northpool.tiledispatch.producer.TileLayoutProducer;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import org.apache.commons.lang3.StringUtils;

public class AreaStatisCutTask
extends AbstractTileDispatchTask {
    ILayer layer;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    protected String[] groupFields;

    public AreaStatisCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, String[] groupFields) {
        super(name);
        this.layer = layer;
        this.grid = grid;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.mongodbDataSource = dataSource;
        this.groupFields = groupFields;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        this.bbox = StringUtils.isNotBlank((CharSequence)((DataServiceBean)dataService.getBean()).getBbox()) ? ((DataServiceBean)dataService.getBean()).getBbox() : this.bbox;
        this.buildStages(LAYER_TYPE.layer);
        Client client = dataService.getClient();
        IAreaTileInfo storageInfo = this.createStorageInfo(dataService);
        dataService.addAreaTileInfo(storageInfo);
        try {
            client.getDataServiceManager().update((Object)dataService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildStages(LAYER_TYPE layerType) {
        int end = this.beginLevel;
        TileConsumeStage stage = null;
        Integer filterLevel = null;
        ITileConsumer tileConsumer = this.createConsumer(this.beginLevel, this.beginLevel, filterLevel);
        String consumeStageName = "\u751f\u4ea7" + this.beginLevel + "\u81f3" + end + "\u7ea7\u522b\u7edf\u8ba1\u74e6\u7247";
        stage = new TileConsumeStage(consumeStageName, tileConsumer);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
    }

    private ITileConsumer createConsumer(int start, int end, Integer filterLevel) {
        AreaStatisCell cutterCell = new AreaStatisCell(this.layer, this.grid, this.groupFields, null, Integer.valueOf(start));
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(start);
        IDataSet dbDataSet = layerLevel.getDataSet();
        ITable table = null;
        try {
            table = dbDataSet.getDataService().getTable();
        }
        catch (Exception exception) {
            throw new Message(exception.getMessage());
        }
        String[] fields = new String[this.groupFields.length + 2];
        System.arraycopy(this.groupFields, 0, fields, 0, this.groupFields.length);
        fields[this.groupFields.length] = dbDataSet.getIdField();
        fields[this.groupFields.length + 1] = dbDataSet.getSpatialField();
        QueryFilter filter = new QueryFilter();
        filter.setOutputFieldNames(fields);
        IScroll scroll = table.mapDao().scrollArray(filter, Integer.valueOf(1000));
        FeatureAreaHandler handlerStream = new FeatureAreaHandler(this.executor, 1, (ITileCutterCell)cutterCell, this.saver, new AreaStatisTileDocumentEncoder());
        handlerStream.setResume(this.resume);
        ITileConsumer tileConsumer = null;
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileProducer createProducer(int start, int end, ITileLayoutPrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer(cell, this.saver, this.executor, start, end, this.grid, this.bbox, this.layer.getId(), new GridExtentDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private MongoTileSaver createTileSaver() {
        IAreaTileInfo areaTileInfo;
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (!this.resume && (areaTileInfo = dataService.getAreaTileInfo()) != null) {
            areaTileInfo.drop();
        }
        String storageName = dataService.getAreaStorageName();
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        MongodbDao mongoDao = tileSaver.getMongoDao();
        mongoDao.createIndex(new String[]{MongoTileSaver.fkey});
        return tileSaver;
    }

    private IAreaTileInfo createStorageInfo(IDataService dataService) {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName(dataService.getAreaStorageName());
        storageInfoBean.setCompleted(false);
        AreaTileInfoBean featureTileInfoBean = new AreaTileInfoBean();
        featureTileInfoBean.setStorageInfo(storageInfoBean);
        featureTileInfoBean.setGroupFields(this.groupFields);
        return new AreaTileInfoShell(dataService.getClient(), featureTileInfoBean);
    }

    @Override
    public void success() throws Exception {
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        Client client = dataService.getClient();
        IStorageInfo storageInfo = dataService.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            client.getDataServiceManager().update((Object)dataService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.success();
    }
}

