/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task;

import com.northpool.exception.Message;
import com.northpool.gis.vector_cut.screenloction.cell.FeatureTileCutCell;
import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.MongodbDao;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.sql.jdbc.IJDBCGenericDao;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoShell;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.abstractclass.AbstractDataConsumer;
import com.northpool.tiledispatch.consumer.abstractclass.SubDataConsumer;
import com.northpool.tiledispatch.consumer.buffer.FeatureWriterBuffer;
import com.northpool.tiledispatch.consumer.handler.FeatureTileCutHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.FeatureTileDocumentEncoder;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeatureTileCutTask
extends AbstractTileDispatchTask {
    ILayer layer;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    protected String[] groupFields;
    String areaField;

    public FeatureTileCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer level, String[] groupFields, String areaField) {
        super(name);
        this.layer = layer;
        this.grid = grid;
        this.beginLevel = level;
        this.mongodbDataSource = dataSource;
        this.groupFields = groupFields;
        this.areaField = areaField;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        this.buildStages(LAYER_TYPE.layer);
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        Client client = dataService.getClient();
        IFeatureTileInfo storageInfo = this.createFeatureTileInfo(dataService);
        dataService.addFeatureTileInfo(storageInfo);
        try {
            client.getDataServiceManager().update((Object)dataService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildStages(LAYER_TYPE layerType) {
        int end = this.beginLevel;
        ITileConsumer tileConsumer = this.createConsumer(this.beginLevel);
        String consumeStageName = "\u751f\u4ea7" + this.beginLevel + "\u81f3" + end + "\u7ea7\u522b\u8981\u7d20\u74e6\u7247";
        TileConsumeStage stage = new TileConsumeStage(consumeStageName, tileConsumer);
        stage.setLogger(this.cutLogger);
        this.stages.add(stage);
    }

    private ITileConsumer createConsumer(int start) {
        FeatureTileCutCell cutterCell = new FeatureTileCutCell(this.layer, this.grid, this.groupFields, this.areaField, Integer.valueOf(start));
        ILayerLevel layerLevel = (ILayerLevel)this.layer.getLevelMap().get(start);
        IDataSet dbDataSet = layerLevel.getDataSet();
        ITable table = null;
        try {
            table = dbDataSet.getDataService().getTable();
        }
        catch (Exception exception) {
            throw new Message(exception.getMessage());
        }
        int filedsNum = this.groupFields.length + 2;
        if (this.areaField != null) {
            ++filedsNum;
        }
        String[] fields = new String[filedsNum];
        System.arraycopy(this.groupFields, 0, fields, 0, this.groupFields.length);
        if (this.areaField != null) {
            fields[this.groupFields.length] = this.areaField;
        }
        fields[fields.length - 2] = dbDataSet.getIdField();
        fields[fields.length - 1] = dbDataSet.getSpatialField();
        IJDBCGenericDao ijdbcGenericDao = ((DbDataSource)table.getDataSource()).genericDao();
        String tablename = table.getTablename();
        String idField = table.getIdField();
        String sql = "select min(" + idField + ") as minid, max(" + idField + ") as maxid from " + tablename;
        List maps = ijdbcGenericDao.queryBySql(sql, null);
        Map minmaxMap = (Map)maps.get(0);
        Long minId = Long.valueOf(minmaxMap.get("minid").toString());
        Long maxId = Long.valueOf(minmaxMap.get("maxid").toString());
        int split = 5;
        long interval = (maxId - minId) / (long)split;
        FeatureWriterBuffer dataBuffer = new FeatureWriterBuffer(this.saver, new FeatureTileDocumentEncoder(), this.grid);
        ArrayList<SubDataConsumer> subDataConsumers = new ArrayList<SubDataConsumer>(split);
        long current = minId;
        for (int i = 0; i < split; ++i) {
            long endId = i == split - 1 ? maxId + 1L : current + interval;
            String extraFilter = idField + " >= " + current + " and " + idField + " < " + endId;
            QueryFilter filter = new QueryFilter();
            filter.setOutputFieldNames(fields);
            filter.addSQL(extraFilter);
            FeatureTileCutHandler handlerStream = new FeatureTileCutHandler(TileDispatchTaskManager.getInstance().getNewExecutor(), 1, this.grid, (ITileCutterCell)cutterCell, this.saver, dataBuffer);
            handlerStream.setResume(this.resume);
            SubDataConsumer subDataConsumer = new SubDataConsumer(table, handlerStream, filter, null);
            subDataConsumer.init();
            subDataConsumers.add(subDataConsumer);
            current = endId;
        }
        AbstractDataConsumer tileConsumer = new AbstractDataConsumer(subDataConsumers, dataBuffer);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private MongoTileSaver createTileSaver() {
        IFeatureTileInfo featureTileInfo;
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (!this.resume && (featureTileInfo = dataService.getFeatureTileInfo()) != null) {
            featureTileInfo.drop();
        }
        String storageName = dataService.getFeatureStorageName();
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        MongodbDao mongoDao = tileSaver.getMongoDao();
        mongoDao.dropIndex(new String[]{MongoTileSaver.lName});
        mongoDao.dropIndex(new String[]{MongoTileSaver.lName, MongoTileSaver.rName, MongoTileSaver.cName});
        mongoDao.createIndex(new String[]{MongoTileSaver.fkey});
        return tileSaver;
    }

    private IFeatureTileInfo createFeatureTileInfo(IDataService dataService) {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.beginLevel);
        storageInfoBean.setStorageName(dataService.getFeatureStorageName());
        storageInfoBean.setCompleted(false);
        FeatureTileInfoBean featureTileInfoBean = new FeatureTileInfoBean();
        featureTileInfoBean.setStorageInfo(storageInfoBean);
        featureTileInfoBean.setLevel(this.beginLevel);
        featureTileInfoBean.setGroupFields(this.groupFields);
        featureTileInfoBean.setAreaField(this.areaField);
        return new FeatureTileInfoShell(dataService.getClient(), featureTileInfoBean);
    }

    @Override
    public void success() throws Exception {
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        Client client = dataService.getClient();
        IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
        if (featureTileInfo != null) {
            IStorageInfo storageInfo = featureTileInfo.getStorageInfo();
            storageInfo.setCompleted(true);
            try {
                client.getDataServiceManager().update((Object)dataService);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.success();
    }
}

