/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.handler;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.handler.abstractclass.AbstractTileHandlerStream;
import com.northpool.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import java.util.concurrent.ExecutorService;

public class TileDataCutHandler
extends AbstractTileHandlerStream<TileLayout> {
    protected ITileCutterCell<GridExtent, Object[]> cell;
    protected ITileSaver saver;
    protected IDocumentEncoder encoder;

    public TileDataCutHandler(ExecutorService executor, int bufferSize) {
        super(executor, bufferSize);
    }

    public TileDataCutHandler(ExecutorService executor, int bufferSize, ITileCutterCell<GridExtent, Object[]> cell, ITileSaver saver, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.encoder = encoder;
    }

    public TileDataCutHandler(ExecutorService executor, int bufferSize, ITileCutterCell<GridExtent, Object[]> cell, ITileSaver saver, ITileErrorHandler errorHandler, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.errorHandler = errorHandler;
        this.encoder = encoder;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.saver.init();
        this.init = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void handle(TileLayout layout) {
        if (this.executor != null) {
            this.executor.execute(() -> this.handleItem(layout));
        } else {
            this.handleItem(layout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(TileLayout extent) {
        if (this.resume || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        Object[] data = null;
        try {
            data = (Object[])this.cell.cut((Object)extent.getExtent(), null);
            this.saver.saveItem(data, this.encoder);
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }
}

