/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.handler;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.ImgCacheCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.gis.vector_cut.screenloction.cell.options.TileCutOptions;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.handler.abstractclass.AbstractTileHandlerStream;
import com.northpool.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.northpool.tiledispatch.consumer.saver.ImageCacheTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class ImageCacheHandler
extends AbstractTileHandlerStream<TileLayout> {
    protected ITileCutterCell<GridExtent, List<Object[]>> cell;
    protected ImageCacheTileSaver saver;
    protected IDocumentEncoder<Object[]> encoder;
    Boolean cover;

    public ImageCacheHandler(ExecutorService executor, int bufferSize) {
        super(executor, bufferSize);
    }

    public ImageCacheHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ImageCacheTileSaver saver, IDocumentEncoder encoder, Boolean cover) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.encoder = encoder;
        this.cover = cover;
    }

    public ImageCacheHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ImageCacheTileSaver saver, ITileErrorHandler errorHandler, IDocumentEncoder encoder, Boolean cover) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.errorHandler = errorHandler;
        this.encoder = encoder;
        this.cover = cover;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.saver.init();
        this.init = true;
    }

    @Override
    public void flush() {
    }

    @Override
    public void handle(TileLayout layout) {
        GridExtent extent = layout.getExtent();
        String extraFilter = layout.getExtraFilter();
        if (this.executor != null) {
            this.executor.execute(() -> this.handleItem(extent, extraFilter));
        } else {
            this.handleItem(extent, extraFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.error || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.saver.hasRecord(extent, (ImgCacheCell)this.cell)) {
            if (this.cover.booleanValue()) {
                this.saver.remove(extent, (ImgCacheCell)this.cell);
            } else {
                this.count.countDown();
                return;
            }
        }
        TileCutOptions options = new TileCutOptions();
        options.setExtraSqlFilter(extraFilter);
        try {
            this.cell.cut((Object)extent, options);
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }
}

