/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.geotools.http.HTTPResponse;

public class MockHttpResponse
implements HTTPResponse {
    InputStream stream;
    String contentType;
    Map<String, String> headers = new HashMap<String, String>();
    Charset charset = StandardCharsets.UTF_8;

    public MockHttpResponse(InputStream stream, String contentType, String ... headers) {
        this.stream = stream;
        this.contentType = contentType;
        if (headers != null) {
            if (headers.length % 2 != 0) {
                throw new IllegalArgumentException("The headers must be a alternated sequence of keys and values, should have an even number of entries");
            }
            for (int i = 0; i < headers.length; i += 2) {
                String key = headers[i];
                String value = headers[i++];
                this.headers.put(key, value);
            }
        }
    }

    public MockHttpResponse(InputStream stream, String contentType, Charset charset, String ... headers) {
        this(stream, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(File responseFile, String contentType, String ... headers) throws FileNotFoundException {
        this((InputStream)new FileInputStream(responseFile), contentType, headers);
    }

    public MockHttpResponse(File responseFile, String contentType, Charset charset, String ... headers) throws FileNotFoundException {
        this(responseFile, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(URL response, String contentType, String ... headers) throws IOException {
        this(response.openStream(), contentType, headers);
    }

    public MockHttpResponse(URL response, String contentType, Charset charset, String ... headers) throws IOException {
        this(response, contentType, headers);
        this.charset = charset;
    }

    public MockHttpResponse(String response, String contentType, String ... headers) {
        this(response.getBytes(), contentType, headers);
    }

    public MockHttpResponse(String response, String contentType, Charset charset, String ... headers) {
        this(response.getBytes(charset), contentType, new String[0]);
        this.charset = charset;
    }

    public MockHttpResponse(byte[] response, String contentType, String ... headers) {
        this((InputStream)new ByteArrayInputStream(response), contentType, headers);
    }

    public void dispose() {
        try {
            this.stream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public InputStream getResponseStream() throws IOException {
        return this.stream;
    }

    public String getResponseCharset() {
        return this.charset.name();
    }

    public String toString() {
        StringBuilder textBuilder = new StringBuilder();
        try {
            try (Object reader = new BufferedReader(new InputStreamReader(this.stream, this.charset));){
                int c = 0;
                while ((c = ((Reader)reader).read()) != -1) {
                    textBuilder.append((char)c);
                }
            }
            reader = this.contentType + " - " + textBuilder.toString();
            return reader;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.stream.reset();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Deprecated
    public void setResponseCharset(String responseCharset) {
        this.charset = Charset.forName(responseCharset);
    }
}

