/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.dao.impl;

import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.FieldDefn;
import org.gdal.ogr.Layer;
import org.gdal.osr.SpatialReference;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.pumpkin.database.relation.database.bean.GeomeryColumn;
import org.pumpkin.database.relation.database.bean.GeometryInfo;
import org.pumpkin.database.relation.database.bean.GeometryType;
import org.pumpkin.database.relation.database.bean.Index;
import org.pumpkin.database.relation.database.bean.PageResult;
import org.pumpkin.database.relation.database.bean.SpatialDataSet;
import org.pumpkin.database.relation.database.bean.TableColumn;
import org.pumpkin.database.relation.database.bean.UpdateNodeBean;
import org.pumpkin.database.relation.database.connection.OgrConnectionImpl;
import org.pumpkin.database.relation.database.dao.RelationSpatialDao;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.pumpkin.database.relation.database.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrSpatialDao
extends RelationSpatialDao {
    protected DataSource.DataSourceType type = DataSource.DataSourceType.ogr;
    Logger logger = LoggerFactory.getLogger(OgrSpatialDao.class);
    static GeometryFactory factory = new GeometryFactory();
    IOgrReadShell gdalShell;
    DataSource ogrGdbDataSource;

    public OgrSpatialDao(Connection conn) {
        super(conn);
        if (!(conn instanceof OgrConnectionImpl)) {
            throw new BusinessException("\u6570\u636e\u5e93\u8fde\u63a5\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        OgrConnectionImpl fgdbConn = (OgrConnectionImpl)conn;
        this.gdalShell = fgdbConn.getReadShell();
        this.ogrGdbDataSource = this.gdalShell.getDataSource();
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    @Override
    public List<Index> getIndexes(String tableName) throws SQLException {
        return null;
    }

    @Override
    public GeometryInfo getGeometryInfo(String tableName, String geometryField) throws SQLException {
        int geomTypeCode;
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        String shapeField = layer.GetGeometryColumn();
        if (StringUtils.isEmpty((CharSequence)shapeField)) {
            shapeField = "_ogr_geometry_";
        }
        if (!OgrSpatialDao.ogrwkbGeometryType2Dimension(geomTypeCode = layer.GetGeomType()).equals(2)) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u4e0d\u652f\u6301\u6ce8\u518c");
        }
        GeometryType geometryType = OgrSpatialDao.ogrwkbGeometryType2GeometryType(geomTypeCode);
        SpatialReference spatialReference = layer.GetSpatialRef();
        String sridStr = "";
        if (spatialReference != null) {
            sridStr = spatialReference.GetAttrValue("AUTHORITY", 1);
        }
        int srid = 0;
        if (StringUtils.isNotEmpty((CharSequence)sridStr)) {
            srid = Integer.parseInt(sridStr);
        } else {
            int sid = this.tryParseSrid(spatialReference);
            if (sid > 0) {
                srid = sid;
            }
        }
        GeometryInfo info = new GeometryInfo();
        info.setGeometryFieldName(shapeField);
        info.setSrid(srid);
        info.setType(geometryType);
        return info;
    }

    private int tryParseSrid(SpatialReference spatialReference) {
        if (null == spatialReference) {
            return 0;
        }
        String name = spatialReference.GetName();
        if (StringUtils.isBlank((CharSequence)name)) {
            return 0;
        }
        String srfName = name.toUpperCase();
        int srid = 0;
        switch (srfName) {
            case "CGCS 2000": 
            case "CGCS_2000": 
            case "GCS_CGCS_2000": 
            case "GCS_CHINA_GEODETIC_COORDINATE_SYSTEM_2000": 
            case "CHINA GEODETIC COORDINATE SYSTEM 2000": {
                srid = 4490;
                break;
            }
            case "WGS 84": 
            case "GCS_WGS_1984": {
                srid = 4326;
                break;
            }
            case "GCS_XIAN_1980": 
            case "XIAN 1980": {
                srid = 4610;
                break;
            }
            case "GCS_BEIJING_1954": 
            case "BEIJING 1954": {
                srid = 4214;
                break;
            }
        }
        return srid;
    }

    static Integer ogrwkbGeometryType2Dimension(int OGRwkbGeometryType) {
        switch (OGRwkbGeometryType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 3000: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: {
                return 3;
            }
        }
        throw new RuntimeException("\u627e\u4e0d\u5230OGRwkbGeometryType:" + OGRwkbGeometryType + "\u4e0eGEO_TYPE\u7684\u6620\u5c04\u5173\u7cfb");
    }

    static GeometryType ogrwkbGeometryType2GeometryType(int OGRwkbGeometryType) {
        switch (OGRwkbGeometryType) {
            case 1: {
                return GeometryType.POINT;
            }
            case 2: {
                return GeometryType.LINESTRING;
            }
            case 3: {
                return GeometryType.POLYGON;
            }
            case 4: {
                return GeometryType.MULTIPOINT;
            }
            case 5: {
                return GeometryType.MULTILINESTRING;
            }
            case 6: {
                return GeometryType.MULTIPOLYGON;
            }
            case 3001: {
                return GeometryType.POINT;
            }
            case 3002: {
                return GeometryType.LINESTRING;
            }
            case 3003: {
                return GeometryType.POLYGON;
            }
            case 3004: {
                return GeometryType.MULTIPOINT;
            }
            case 3005: {
                return GeometryType.MULTILINESTRING;
            }
            case 3006: {
                return GeometryType.MULTIPOLYGON;
            }
        }
        throw new RuntimeException("\u627e\u4e0d\u5230OGRwkbGeometryType:" + OGRwkbGeometryType + "\u4e0eGeometryType\u7684\u6620\u5c04\u5173\u7cfb");
    }

    @Override
    public Integer getSrid(String tableName) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        return Integer.valueOf(layer.GetSpatialRef().GetAttrValue("AUTHORITY", 1));
    }

    @Override
    public String getExtent(String tableName, String field) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        double[] bbox = layer.GetExtent();
        Envelope envelope = new Envelope(bbox[0], bbox[1], bbox[2], bbox[3]);
        Geometry geometry = factory.toGeometry(envelope);
        return geometry.toText();
    }

    @Override
    public Double[] getBBox(String tableName, String field) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        double[] bbox = layer.GetExtent();
        return new Double[]{bbox[0], bbox[1], bbox[2], bbox[3]};
    }

    @Override
    public Boolean exists(String tableName) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        return layer != null;
    }

    @Override
    public String getPk(String tableName) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        return layer.GetFIDColumn();
    }

    @Override
    public List<TableColumn> getFields(String tableName) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        ArrayList<TableColumn> tableColumns = new ArrayList<TableColumn>();
        for (int i = 0; i < layer.GetLayerDefn().GetFieldCount(); ++i) {
            FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
            TableColumn tableColumn = new TableColumn();
            tableColumn.setName(fieldDefn.GetName());
            tableColumn.setType(fieldDefn.GetFieldTypeName(fieldDefn.GetFieldType()));
            tableColumns.add(tableColumn);
        }
        return tableColumns;
    }

    @Override
    public List<TableColumn> getFieldsWithCommit(String tableName) throws SQLException {
        return this.getFields(tableName);
    }

    @Override
    public List<String> getFieldNames(String tableName) throws SQLException {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        ArrayList<String> tableColumns = new ArrayList<String>();
        for (int i = 0; i < layer.GetLayerDefn().GetFieldCount(); ++i) {
            FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
            tableColumns.add(fieldDefn.GetName());
        }
        return tableColumns;
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields, String sortField, String sortType) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTable(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        if (StringUtils.isEmpty((CharSequence)keyWord)) {
            keyWord = "";
        }
        ArrayList<SpatialDataSet> results = new ArrayList<SpatialDataSet>();
        int count = this.ogrGdbDataSource.GetLayerCount();
        int start = pageIndex * rows;
        int end = Math.min((pageIndex + 1) * rows, count);
        for (int i = start; i < end; ++i) {
            Layer layer = this.ogrGdbDataSource.GetLayer(i);
            if (layer == null || StringUtils.indexOfIgnoreCase((CharSequence)layer.GetName(), (CharSequence)keyWord) < 0) continue;
            SpatialDataSet element = new SpatialDataSet();
            String name = layer.GetName();
            try {
                GeometryInfo geometryInfo = this.getGeometryInfo(name, layer.GetGeometryColumn());
                element.setName(name);
                GeomeryColumn geomeryColumn = new GeomeryColumn(geometryInfo.getGeometryFieldName(), geometryInfo.getSrid(), geometryInfo.getType().toString());
                element.setGeomeryColumnList(Collections.singletonList(geomeryColumn));
                results.add(element);
                continue;
            }
            catch (Exception ex) {
                this.logger.warn("\u56fe\u5c42" + name + "\u4e0d\u7b26\u5408\u8981\u6c42\uff1a" + ex.getMessage());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            int newCount = 0;
            for (int i = 0; i < count; ++i) {
                Layer layer = this.ogrGdbDataSource.GetLayer(i);
                if (StringUtils.indexOfIgnoreCase((CharSequence)layer.GetName(), (CharSequence)keyWord) < 0) continue;
                ++newCount;
            }
            count = newCount;
        }
        return new PageResult<SpatialDataSet>(Long.valueOf(count), results);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTableWithColumns(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        PageResult<SpatialDataSet> tablePages = this.getSpatialTable(pageIndex, rows, keyWord);
        List<SpatialDataSet> tables = tablePages.getData();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (SpatialDataSet item : tables) {
            tableNames.add(item.getName());
        }
        Map<String, List<TableColumn>> tablesColumns = this.getSpatialColumns(tableNames);
        List<Object> columns = new ArrayList();
        if (tables != null && !tables.isEmpty()) {
            for (int i = 0; i < tables.size(); ++i) {
                SpatialDataSet element = tables.get(i);
                element.getGeomeryColumnList().stream().findFirst().ifPresent(geomeryColumn -> element.setSrid(geomeryColumn.getSrid()));
                columns = tablesColumns.get(element.getName());
                element.setColumnList(columns == null ? new ArrayList() : columns);
                element.setIsView(false);
            }
        }
        return tablePages;
    }

    @Override
    public boolean checkSpatial(String tableName, String geometryField) throws SQLException {
        return true;
    }

    public void checkSpatialIndex(String tableName, String geometryField) throws SQLException {
    }

    private Map<String, List<TableColumn>> getSpatialColumns(List<String> tableNames) throws SQLException {
        HashMap<String, List<TableColumn>> tablesColumns = new HashMap<String, List<TableColumn>>();
        for (String tableName : tableNames) {
            Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
            int fieldCount = layer.GetLayerDefn().GetFieldCount();
            ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
            for (int i = 0; i < fieldCount; ++i) {
                FieldDefn fieldDefn = layer.GetLayerDefn().GetFieldDefn(i);
                TableColumn data = new TableColumn();
                String field = fieldDefn.GetName();
                data.setName(field);
                data.setType(fieldDefn.GetFieldTypeName(fieldDefn.GetFieldType()));
                data.setIsPrimary(field.equals(layer.GetFIDColumn()));
                columns.add(data);
            }
            TableColumn data = new TableColumn();
            String fidColumn = layer.GetFIDColumn();
            if (StringUtils.isEmpty((CharSequence)fidColumn)) {
                fidColumn = "FID";
            }
            data.setName(fidColumn);
            data.setType("integer");
            data.setIsPrimary(true);
            columns.add(data);
            data = new TableColumn();
            String geometryColumn = layer.GetGeometryColumn();
            if (StringUtils.isEmpty((CharSequence)geometryColumn)) {
                geometryColumn = "_ogr_geometry_";
            }
            data.setName(geometryColumn);
            data.setType("geometry");
            data.setIsPrimary(false);
            columns.add(data);
            tablesColumns.put(tableName, columns);
        }
        return tablesColumns;
    }

    @Override
    public boolean isView(String viewName) throws SQLException {
        return false;
    }

    @Override
    public void isValidate() {
    }

    @Override
    public Map<String, List<UpdateNodeBean>> getUpdateNode(String schema) throws SQLException {
        throw new UnsupportedOperationException("not support");
    }

    @Override
    public String getSequenceNameForTable(String tableName) throws SQLException {
        return null;
    }

    public List<String> getStringFieldValues(String tableName, String fieldName) {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        if (layer == null) {
            throw new RuntimeException("\u8868\u540d\u4e0d\u5b58\u5728\uff1a" + tableName);
        }
        layer.ResetReading();
        Feature feature = layer.GetNextFeature();
        ArrayList<String> fieldValues = new ArrayList<String>();
        while (null != feature) {
            String fieldValue = feature.GetFieldAsString(fieldName);
            if (!fieldValues.contains(fieldValue)) {
                fieldValues.add(fieldValue);
            }
            feature = layer.GetNextFeature();
        }
        return fieldValues;
    }

    public List<Double> getDoubleFieldValues(String tableName, String fieldName) {
        Layer layer = this.ogrGdbDataSource.GetLayer(tableName);
        if (layer == null) {
            throw new RuntimeException("\u8868\u540d\u4e0d\u5b58\u5728\uff1a" + tableName);
        }
        layer.ResetReading();
        Feature feature = layer.GetNextFeature();
        ArrayList<Double> fieldValues = new ArrayList<Double>();
        while (null != feature) {
            Double fieldValue = feature.GetFieldAsDouble(fieldName);
            if (!fieldValues.contains(fieldValue)) {
                fieldValues.add(fieldValue);
            }
            feature = layer.GetNextFeature();
        }
        return fieldValues;
    }

    public long getFeatureCount(String tableName) {
        return this.ogrGdbDataSource.GetLayer(tableName).GetFeatureCount();
    }
}

