/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.datasource.impl;

import com.northpool.resources.datasource.ogr.FGDBDataSource;
import com.northpool.resources.datasource.ogr.IOgrShellDataSource;
import com.northpool.resources.datasource.ogr.ShapeDataSource;
import java.io.IOException;
import java.sql.Connection;
import org.pumpkin.database.relation.database.connection.OgrConnectionImpl;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgrDataSource
extends DataSource {
    private Logger logger = LoggerFactory.getLogger(OgrDataSource.class);
    OgrConnectionImpl connection;
    org.gdal.ogr.DataSource ogrDataSource;

    public OgrDataSource(String filePath) throws IOException {
        OgrConnectionImpl ogrConnection;
        FGDBDataSource dataSource = null;
        if (filePath.endsWith(".gdb")) {
            dataSource = new FGDBDataSource(filePath);
        } else if (filePath.endsWith(".shp")) {
            dataSource = new ShapeDataSource(filePath);
        }
        this.connection = ogrConnection = new OgrConnectionImpl((IOgrShellDataSource)dataSource, filePath);
        this.ogrDataSource = ogrConnection.getReadShell().getDataSource();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }
}

