/*
 * Decompiled with CFR 0.152.
 */
package org.pumpkin.database.relation.database.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.pumpkin.database.relation.database.bean.GeomeryColumn;
import org.pumpkin.database.relation.database.bean.GeometryInfo;
import org.pumpkin.database.relation.database.bean.GeometryType;
import org.pumpkin.database.relation.database.bean.Index;
import org.pumpkin.database.relation.database.bean.PageResult;
import org.pumpkin.database.relation.database.bean.SpatialDataSet;
import org.pumpkin.database.relation.database.bean.TableColumn;
import org.pumpkin.database.relation.database.bean.UpdateNodeBean;
import org.pumpkin.database.relation.database.dao.RelationSpatialDao;
import org.pumpkin.database.relation.database.datasource.DataSource;
import org.pumpkin.database.relation.database.exception.BusinessException;
import org.pumpkin.database.relation.database.utils.PreparedStatementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlSpatialDao
extends RelationSpatialDao {
    protected DataSource.DataSourceType type = DataSource.DataSourceType.mysql;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public MysqlSpatialDao(Connection conn) {
        super(conn);
    }

    @Override
    public GeometryInfo getGeometryInfo(String tableName, String geometryField) throws SQLException {
        GeometryInfo info;
        String schema = this.conn.getCatalog();
        if (StringUtils.isEmpty((CharSequence)geometryField)) {
            String sql = "select column_name from information_schema.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME = ? and DATA_TYPE in ('geometry','point','linestring', 'polygon', 'multipoint', 'multilinestring', 'multipolygon')";
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{schema, tableName});
            Boolean exist = false;
            int geoNum = 0;
            while (rs.next()) {
                ++geoNum;
                if (!StringUtils.isNotEmpty((CharSequence)rs.getString("column_name"))) continue;
                geometryField = rs.getString("column_name");
            }
            if (geoNum > 1) {
                throw new BusinessException("\u8bf7\u660e\u786e\u6307\u5b9a\u7a7a\u95f4\u5b57\u6bb5");
            }
            ps.close();
        }
        if ((info = this.getGeometryInfoByRow(tableName, geometryField)) != null) {
            info.setGeometryFieldName(geometryField);
        }
        return info;
    }

    private GeometryInfo getGeometryInfoByRow(String tableName, String geometryField) throws SQLException {
        GeometryInfo info = null;
        String typeSql = "SELECT geometrytype(" + geometryField + ") as type, st_srid(" + geometryField + ") as srid from " + tableName + " where " + geometryField + " is not null limit  1  offset 0";
        String geometryType = null;
        Integer srid = null;
        try (PreparedStatement nps = this.conn.prepareStatement(typeSql);
             ResultSet nrs = nps.executeQuery();){
            while (nrs.next()) {
                info = new GeometryInfo();
                geometryType = nrs.getString("type");
                srid = nrs.getInt("srid");
                info.setType(GeometryType.valueOf(geometryType.toUpperCase()));
                info.setSrid(srid);
            }
        }
        return info;
    }

    @Override
    public Integer getSrid(String tableName) throws SQLException {
        return null;
    }

    @Override
    public String getExtent(String tableName, String field) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ST_ASTEXT(ST_Envelope(" + field + ")) as wkt from " + tableName);
        PreparedStatement ps = this.conn.prepareStatement(sql.toString());
        ResultSet rs = ps.executeQuery();
        String wkt = null;
        while (rs.next()) {
            wkt = rs.getString("wkt");
        }
        ps.close();
        return wkt;
    }

    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields) throws SQLException {
        return this.list(tableName, conn, pageIndex, rows, keyWord, wkt, geomField, Fields, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> list(String tableName, Connection conn, Integer pageIndex, Integer rows, String keyWord, String wkt, String geomField, List<TableColumn> Fields, String sortField, String sortType) throws SQLException {
        Statement ps = null;
        ResultSet rs = null;
        HashMap<String, Object> datas = new HashMap<String, Object>();
        ArrayList<String> allFields = new ArrayList<String>();
        ArrayList dataslist = new ArrayList();
        ArrayList<String> searchFields = new ArrayList<String>();
        try {
            String searchType = "longtext,bigint,int,tinyint,varchar,decimal";
            for (TableColumn field : Fields) {
                String type = field.getType();
                String name = field.getName();
                allFields.add(name);
                if (!searchType.contains(type)) continue;
                String notNullField = "COALESCE(" + name + " ,'')";
                if ("bigint".equals(type) || "decimal".equals(type) || "tinyint".equals(type)) {
                    notNullField = "COALESCE(" + name + " ,0)";
                }
                searchFields.add(notNullField);
            }
            List fieldsList = allFields.stream().map(dd -> dd).collect(Collectors.toList());
            fieldsList.remove(geomField);
            fieldsList.add("ST_AsText(" + geomField + ") as geom");
            String allFieldsStr = StringUtils.join(fieldsList, (String)",");
            String text = StringUtils.join(searchFields, (String)"||'-'||");
            text = "'' || " + text;
            StringBuffer sql = new StringBuffer();
            sql.append("select ");
            sql.append(allFieldsStr);
            sql.append(" from ");
            sql.append(tableName);
            Object[] paras = null;
            if (wkt != null && !"".equals(wkt)) {
                sql.append(" where ");
                sql.append(text);
                sql.append(" like ?");
                paras = new Object[]{"%" + wkt + "%"};
            }
            ps = conn.prepareStatement(sql.toString().replace(allFieldsStr, "count(*) as num"));
            rs = paras != null ? PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras) : PreparedStatementUtils.executeQuery((PreparedStatement)ps, new Object[0]);
            long count = -1L;
            while (rs.next()) {
                count = rs.getInt("num");
            }
            ps.close();
            if (StringUtils.isNotBlank((CharSequence)sortField)) {
                String type = StringUtils.isNotEmpty((CharSequence)sortType) ? sortType : "ASC";
                sql.append(" ORDER BY ").append(sortField).append(" ").append(type);
            }
            paras = paras != null ? new Object[]{"%" + wkt + "%", rows, pageIndex * rows} : new Object[]{rows, pageIndex * rows};
            sql.append(" limit ?");
            sql.append(" offset ?");
            ps = conn.prepareStatement(sql.toString());
            rs = PreparedStatementUtils.executeQuery((PreparedStatement)ps, paras);
            int fieldsNum = allFields.size();
            allFields.remove(geomField);
            allFields.add("geom");
            HashMap<String, Object> row = null;
            String field = null;
            dataslist = new ArrayList();
            while (rs.next()) {
                row = new HashMap<String, Object>();
                for (int i = 0; i < fieldsNum; ++i) {
                    field = (String)allFields.get(i);
                    row.put(field, rs.getObject(field));
                }
                dataslist.add(row);
            }
            datas.put("count", count);
            datas.put("columns", allFields);
            datas.put("data", dataslist);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return datas;
    }

    @Override
    public Boolean exists(String tableName) throws SQLException {
        String schema = this.conn.getCatalog();
        String sql = "select 1 as exist from information_schema.tables  where table_schema = ? and table_name = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{schema, tableName});
        Boolean exist = false;
        while (rs.next()) {
            if (rs.getInt("exist") != 1) continue;
            exist = true;
        }
        ps.close();
        return exist;
    }

    @Override
    public String getPk(String tableName) throws SQLException {
        StringBuffer columnSql = new StringBuffer();
        columnSql.append("SELECT column_name FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE table_name = ? AND constraint_name='PRIMARY'");
        PreparedStatement ps = this.conn.prepareStatement(columnSql.toString());
        ps.setString(1, tableName);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return rs.getString("column_name");
        }
        ps.close();
        return null;
    }

    public Map<String, String> getPkByTables(List<String> tables) throws SQLException {
        HashMap<String, String> pks = new HashMap<String, String>();
        String tableNamesStr = "'" + StringUtils.join(tables, (String)"','") + "'";
        StringBuffer columnSql = new StringBuffer();
        columnSql.append("SELECT table_name, column_name FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE table_name in (" + tableNamesStr + ") AND constraint_name='PRIMARY'");
        PreparedStatement ps = this.conn.prepareStatement(columnSql.toString());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            pks.put(rs.getString("table_name"), rs.getString("column_name"));
        }
        ps.close();
        return pks;
    }

    @Override
    public List<TableColumn> getFields(String tableName) throws SQLException {
        String schema = this.conn.getCatalog();
        String sql = "select column_name,data_type from information_schema.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql.toString());
        ps.setString(1, schema);
        ps.setString(2, tableName);
        ResultSet rs = ps.executeQuery();
        TableColumn field = null;
        ArrayList<TableColumn> fields = new ArrayList<TableColumn>();
        while (rs.next()) {
            field = new TableColumn();
            field.setName(rs.getString("column_name"));
            field.setType(rs.getString("data_type"));
            fields.add(field);
        }
        ps.close();
        return fields;
    }

    @Override
    public List<TableColumn> getFieldsWithCommit(String tableName) throws SQLException {
        return this.getFields(tableName);
    }

    @Override
    public List<String> getFieldNames(String tableName) throws SQLException {
        String schema = this.conn.getCatalog();
        String sql = "select column_name from information_schema.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setString(1, schema);
        ps.setString(2, tableName);
        ResultSet rs = ps.executeQuery();
        ArrayList<String> fields = new ArrayList<String>();
        while (rs.next()) {
            fields.add(rs.getString("column_name"));
        }
        ps.close();
        return fields;
    }

    @Override
    public boolean isView(String viewName) throws SQLException {
        String schema = this.conn.getCatalog();
        String sql = "SELECT count(1) as count from information_schema.VIEWS where TABLE_SCHEMA = ? and TABLE_NAME = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ps.setString(1, viewName);
        ps.setString(2, schema);
        ResultSet rs = ps.executeQuery();
        Integer count = null;
        while (rs.next()) {
            count = rs.getInt("count");
        }
        ps.close();
        return Integer.valueOf(1).equals(count);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTable(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            keyWord = "";
        }
        ArrayList<SpatialDataSet> results = new ArrayList<SpatialDataSet>();
        String schema = this.conn.getCatalog();
        String baseSql = "select table_name, group_concat(column_name) as names from information_schema.COLUMNS where TABLE_SCHEMA = ? and DATA_TYPE in ('geometry','point','linestring', 'polygon', 'multipoint', 'multilinestring', 'multipolygon') and UPPER(table_name) like ? group by table_name ";
        String pageSql = baseSql + "order by table_name limit ?,? ";
        PreparedStatement ps = this.conn.prepareStatement(pageSql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{schema, "%" + StringUtils.upperCase((String)keyWord) + "%", pageIndex * rows, rows});
        while (rs.next()) {
            SpatialDataSet dataSet = new SpatialDataSet();
            dataSet.setName(rs.getString("table_name"));
            ArrayList<GeomeryColumn> list = new ArrayList<GeomeryColumn>();
            for (String geomName : rs.getString("names").split(",")) {
                list.add(new GeomeryColumn(geomName, 0, null));
            }
            dataSet.setGeomeryColumnList(list);
            results.add(dataSet);
        }
        ps.close();
        String countSql = "select count(*) as count from ( " + baseSql + " ) o";
        ps = this.conn.prepareStatement(countSql);
        rs = PreparedStatementUtils.executeQuery(ps, new Object[]{schema, StringUtils.upperCase((String)keyWord)});
        Long count = 0L;
        while (rs.next()) {
            count = rs.getLong("count");
        }
        ps.close();
        return new PageResult<SpatialDataSet>(count, results);
    }

    @Override
    public PageResult<SpatialDataSet> getSpatialTableWithColumns(Integer pageIndex, Integer rows, String keyWord) throws SQLException {
        PageResult<SpatialDataSet> tablePages = this.getSpatialTable(pageIndex, rows, keyWord);
        List<SpatialDataSet> tables = tablePages.getData();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (SpatialDataSet item : tables) {
            tableNames.add(item.getName());
        }
        Map<String, List<TableColumn>> tablesColumns = this.getSpatialColumns(tableNames);
        List<Object> columns = new ArrayList();
        if (tables != null && !tables.isEmpty()) {
            for (int i = 0; i < tables.size(); ++i) {
                SpatialDataSet elment;
                columns = tablesColumns.get((elment = tables.get(i)).getName());
                elment.setColumnList(columns == null ? new ArrayList() : columns);
            }
        }
        return tablePages;
    }

    private Map<String, List<TableColumn>> getSpatialColumns(List<String> tableNames) throws SQLException {
        HashMap<String, List<TableColumn>> result = new HashMap<String, List<TableColumn>>();
        if (tableNames == null || tableNames.isEmpty()) {
            return null;
        }
        Map<String, String> pks = this.getPkByTables(tableNames);
        String tableNamesStr = "'" + StringUtils.join(tableNames, (String)"','") + "'";
        String schema = this.conn.getCatalog();
        String sql = "select table_name, column_name from information_schema.COLUMNS where TABLE_SCHEMA = '" + schema + "' and table_name in (" + tableNamesStr + ")";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        String tableName = null;
        TableColumn data = null;
        List<TableColumn> columns = new ArrayList();
        while (rs.next()) {
            tableName = rs.getString("table_name");
            columns = (List)result.get(tableName);
            if (columns == null) {
                columns = new ArrayList();
                result.put(tableName, columns);
            }
            data = new TableColumn();
            data.setName(rs.getString("column_name"));
            data.setIsPrimary(data.getName().equals(pks.get(tableName)));
            columns.add(data);
        }
        return result;
    }

    @Override
    public boolean checkSpatial(String tableName, String geometryField) throws SQLException {
        boolean isView = this.isView(tableName);
        if (isView) {
            this.checkViewVid(tableName);
        } else {
            String pk = this.getPk(tableName);
            if (StringUtils.isEmpty((CharSequence)pk)) {
                throw new BusinessException("\u8868 " + tableName + " \u7f3a\u5c11\u4e3b\u952e");
            }
            this.checkSpatialIndex(tableName, geometryField);
        }
        return true;
    }

    @Override
    public Map<String, List<UpdateNodeBean>> getUpdateNode(String schema) throws SQLException {
        return null;
    }

    @Override
    public String getSequenceNameForTable(String tableName) throws SQLException {
        return null;
    }

    private void checkSpatialIndex(String tableName, String geometryField) throws SQLException {
        String schema = this.conn.getCatalog();
        String sql = "SELECT count(*) as count FROM information_schema.statistics a where a.TABLE_SCHEMA = ? and a.TABLE_NAME = ? and a.COLUMN_NAME = ?";
        PreparedStatement ps = this.conn.prepareStatement(sql);
        ResultSet rs = PreparedStatementUtils.executeQuery(ps, new Object[]{schema, tableName, geometryField});
        Long count = 0L;
        while (rs.next()) {
            count = rs.getLong("count");
        }
        if (count < 1L) {
            throw new RuntimeException("\u8868" + schema + "." + tableName + "\u7a7a\u95f4\u5b57\u6bb5" + geometryField + "\u4e0d\u5b58\u5728\u6216\u7f3a\u5c11\u7a7a\u95f4\u7d22\u5f15");
        }
    }

    @Override
    public DataSource.DataSourceType getType() {
        return this.type;
    }

    @Override
    public List<Index> getIndexes(String tableName) throws SQLException {
        return null;
    }
}

