/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.jts;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.ProjCoordinate;

public class GeometryProject {
    public static Geometry transformGeometry(Geometry geometry, CoordinateTransform transform) {
        if (geometry == null) {
            return null;
        }
        PrecisionModel preci = new PrecisionModel();
        GeometryFactory geometryFactory = new GeometryFactory(preci);
        if (geometry instanceof Point) {
            Coordinate transformed = GeometryProject.transformCoordinate(geometry.getCoordinate(), transform);
            return geometryFactory.createPoint(transformed);
        }
        if (geometry instanceof LineString) {
            Coordinate[] coordinates = geometry.getCoordinates();
            Coordinate[] transformedCoordinates = new Coordinate[coordinates.length];
            for (int i = 0; i < coordinates.length; ++i) {
                transformedCoordinates[i] = GeometryProject.transformCoordinate(coordinates[i], transform);
            }
            return geometryFactory.createLineString(transformedCoordinates);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            LinearRing shell = (LinearRing)GeometryProject.transformGeometry((Geometry)polygon.getExteriorRing(), transform);
            LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes[i] = (LinearRing)GeometryProject.transformGeometry((Geometry)polygon.getInteriorRingN(i), transform);
            }
            return geometryFactory.createPolygon(shell, holes);
        }
        if (geometry instanceof GeometryCollection) {
            int numGeometries = geometry.getNumGeometries();
            Geometry[] transformedGeometries = new Geometry[numGeometries];
            for (int i = 0; i < numGeometries; ++i) {
                transformedGeometries[i] = GeometryProject.transformGeometry(geometry.getGeometryN(i), transform);
            }
            return geometryFactory.buildGeometry((Collection)Arrays.stream(transformedGeometries).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("Unsupported geometry type: " + geometry.getGeometryType());
    }

    private static Coordinate transformCoordinate(Coordinate coordinate, CoordinateTransform transform) {
        ProjCoordinate source = new ProjCoordinate(coordinate.x, coordinate.y);
        ProjCoordinate target = new ProjCoordinate();
        transform.transform(source, target);
        return new Coordinate(target.x, target.y);
    }
}

