/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.jts;

import com.sfg.debugger.jts.GeometryProject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JTSwork {
    private static Logger logger = LoggerFactory.getLogger(JTSwork.class);

    public static void main(String[] args) {
        try {
            JTSwork.testProj();
            System.out.println("=== END ===");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void testProj() {
        String wktSrc = "MULTIPOLYGON (((19867182.156418376 2794071.3999848943, 19821904.64859199 2714303.7381947674, 19777586.958960507 2642696.34082477, 19775203.24055306 2620724.012342132, 19992772.768898763 2631962.155117797, 19988115.99420501 2659221.4416996166, 19903609.87978757 2652592.1654940443, 19902108.50339578 2795063.3247611164, 19877714.556148876 2794361.0208613607, 19879931.569949213 2651127.320614031, 19816735.145029306 2645940.405177389, 19876467.256725512 2794326.294151115, 19867182.156418376 2794071.3999848943)), ((19881018.83193499 2543855.2335286024, 19878905.63614773 2626103.12447762, 19901911.31874786 2626721.3240641993, 19904153.491297286 2544458.5108956858, 19881018.83193499 2543855.2335286024)))";
        String wktGeo = com.northpool.spatial.proj.GeometryProject.transformWKT((String)wktSrc, (int)4497, (int)4490);
        System.out.println("\u8f6c\u7ecf\u7eac\u5ea6\uff1a");
        System.out.println(wktGeo);
    }

    public static void testCurve() {
        Object a = null;
    }

    public static void proj() throws Exception {
        GeometryFactory geometryFactory = new GeometryFactory();
        WKTReader wktReader = new WKTReader(geometryFactory);
        String subway = "LINESTRING(114.42417501069 30.595833587647, 114.451640831 30.540901947022, 114.44958089448 30.511376190186)";
        LineString lineString = (LineString)wktReader.read(subway);
        String sourceCRS = "EPSG:4326";
        String targetCRS = "EPSG:4525";
        CRSFactory crsFactory = new CRSFactory();
        CoordinateReferenceSystem crsSrc = crsFactory.createFromName(sourceCRS);
        CoordinateReferenceSystem crsTarget = crsFactory.createFromName(targetCRS);
        CoordinateTransformFactory ctFactory = new CoordinateTransformFactory();
        CoordinateTransform proj = ctFactory.createTransform(crsSrc, crsTarget);
        LineString projectedLine = (LineString)GeometryProject.transformGeometry((Geometry)lineString, proj);
        System.out.println("Projected line: " + projectedLine.toString());
        double lengthInMeters = projectedLine.getLength();
        System.out.println("Distance in meters: " + lengthInMeters);
    }
}

