/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.rtt;

import com.github.javaparser.utils.Log;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.service.IDataSetService;
import com.northpool.gis.vector_cut.screenloction.service.impl.DataSetService;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.sfg.debugger.config.ConfBean;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryFeatures {
    private static Logger LOG = LoggerFactory.getLogger(QueryFeatures.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static String gridName = "tdt_degree_base512";
    static Client client;
    static IVectorServiceManager svcmanager;
    static IVectorService service;
    static String mapName;
    static String layerName;
    static IDataSetService dataSetService;
    static Map<String, List<FieldsConfig>> layerFieldsDict;
    static Map<String, Integer> propNumsDict;
    static boolean printCoords;

    public static void main(String[] args) {
        try {
            QueryFeatures.setUp();
            QueryFeatures.queryAll();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = false;
        GlobalTileSettings.bAccurateIntersect = false;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        GlobalTileSettings.RTT_THREAD_COUNT = 1;
        int poolSize = 10;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl, true);
        svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(mapName);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5730\u56fe\u670d\u52a1\uff1a" + mapName);
        }
        dataSetService = new DataSetService();
        System.out.println("=== config completed ===");
    }

    private static void queryAll() throws Exception {
        String layerType = "layer";
        String filter = null;
        String spatialFilter = null;
        int nOffset = 0;
        int nLimit = 1;
        String fields = null;
        String ids = null;
        int level = 7;
        boolean withGeometry = true;
        boolean withExtent = false;
        boolean withCenter = false;
        byte[] vtileData = dataSetService.getDataSetData(service, layerName, filter, spatialFilter, fields, ids, Integer.valueOf(nOffset), Integer.valueOf(nLimit), Integer.valueOf(level), Boolean.valueOf(withGeometry), Boolean.valueOf(withExtent), Boolean.valueOf(withCenter));
        LOG.info("\u8981\u7d20\u67e5\u8be2\u8fd4\u56de\u5b57\u8282\u6570\uff1a {}", (Object)String.format("%,d", vtileData.length));
        LOG.info("\u8981\u7d20\u67e5\u8be2\u7ed3\u679c\uff1a\r\n {}", (Object)new String(vtileData));
    }

    static {
        mapName = "jy30w";
        layerName = "jy30w";
        printCoords = true;
    }
}

