/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.buzidata;

import com.github.javaparser.utils.Log;
import com.mongodb.client.model.CreateCollectionOptions;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.MongodbDao;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.sfg.debugger.config.ConfBean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MogoWork {
    private static Logger LOG = LoggerFactory.getLogger(MogoWork.class);
    static ConfBean conf;
    static Client client;
    static String collectionName;
    static MongodbFactory mogoFactory;

    public static void main(String[] args) {
        try {
            MogoWork.setUp();
            collectionName = "testTable";
            MogoWork.shardCollection();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 2;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        conf = new ConfBean();
        client = new Client(MogoWork.conf.mogoBuziDB, MogoWork.conf.zkUrl, MogoWork.conf.mapserverUrl);
        String mogoUrl = MogoWork.conf.mogoTileDbUrl;
        MongodbDataSource mongodbDataSource = new MongodbDataSource(mogoUrl);
        mogoFactory = mongodbDataSource.factory();
    }

    private static void shardCollection() {
        LOG.info("\u5224\u65ad\u662f\u5426\u5b58\u5728 collection: " + collectionName);
        boolean isExist = mogoFactory.collectionExist(collectionName);
        if (!isExist) {
            LOG.info("\u521b\u5efa collection: " + collectionName);
            mogoFactory.createCollection(collectionName, new CreateCollectionOptions());
            MongodbDao dao = mogoFactory.getDao(collectionName);
            dao.createIndex(new String[]{"flevel", "fx", "fy"});
            boolean enableSharding = true;
            if (enableSharding) {
                try {
                    mogoFactory.setDBSharding();
                }
                catch (Exception ex) {
                    LOG.error("\u6570\u636e\u5f00\u542f\u5206\u7247\u5931\u8d25", (Throwable)ex);
                }
                LOG.info("\u6307\u5b9a\u96c6\u5408{}\u7684\u5206\u7247\u5b57\u6bb5: {}", (Object)collectionName, (Object)"fx");
                try {
                    mogoFactory.shardCollectionHashed(collectionName, "fx");
                }
                catch (Exception ex) {
                    LOG.error("\u8bbe\u7f6e\u5206\u7247\u5b57\u6bb5\u5931\u8d25", (Throwable)ex);
                }
            }
        } else {
            LOG.info("\u5df2\u7ecf\u5b58\u5728\u6570\u636e\u96c6\uff1a" + collectionName);
        }
    }
}

