/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.buzidata;

import com.github.javaparser.utils.Log;
import com.mongodb.client.MongoCollection;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.sfg.debugger.buzidata.CheckTileMongodb;
import com.sfg.debugger.config.ConfBean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMongoCfg {
    private static Logger LOG = LoggerFactory.getLogger(CheckTileMongodb.class);
    private static MongodbFactory mogoFactory;
    static ConfBean conf;
    static Client client;

    public static void main(String[] args) {
        try {
            TestMongoCfg.setUp();
            TestMongoCfg.checkWork();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 2;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        conf = new ConfBean();
        client = new Client(TestMongoCfg.conf.mogoBuziDB, TestMongoCfg.conf.zkUrl, TestMongoCfg.conf.mapserverUrl, true);
        String mogoUrl = "mongodb://localhost:27017/vtile2024_vector";
        MongodbDataSource mongodbDataSource = new MongodbDataSource(mogoUrl);
        mogoFactory = mongodbDataSource.factory();
    }

    private static void checkWork() throws Exception {
        String collectionName = "Shp1234_utfgrid";
        MongoCollection coll = mogoFactory.getCollection(collectionName);
        long count = coll.countDocuments();
        System.out.println(count);
    }
}

