/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.cuttask;

import com.github.javaparser.utils.Log;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.task.TileLayerCutTask;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.sfg.debugger.config.ConfBean;
import com.sfg.debugger.cuttask.TaskLauncher;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CutDataService {
    private static Logger LOG = LoggerFactory.getLogger(CutDataService.class);
    static QuadtreeGrid grid = GridManager.getQuadtreeGrid((Constants.GRID_UNIT)Constants.GRID_UNIT.degree, (Constants.GRID_BASE)Constants.GRID_BASE.base512, (Constants.GRID_TYPE)Constants.GRID_TYPE.tdt);
    static Client client;
    static IVectorService service;
    static MongodbDataSource tileMogoDS;
    static String dataServiceName;
    static String dataServiceId;
    static int l1;
    static int l2;
    static Map<String, Map<String, String>> levelDataFilters;

    public static void main(String[] args) {
        try {
            CutDataService.setUp();
            CutDataService.cutData();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        GlobalTileSettings.bAccurateCut = true;
        GlobalTileSettings.bAccurateIntersect = false;
        GlobalTileSettings.SHOW_ERROR_DATA = true;
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        GlobalTileSettings.RTT_THREAD_COUNT = 1;
        int poolSize = 100;
        DBPoolParameter.DEFAULT.setMinIdle(1);
        DBPoolParameter.DEFAULT.setInitialSize(1);
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        ConfBean conf = new ConfBean();
        client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl);
        IVectorServiceManager svcmanager = client.getVectorServiceManager();
        service = (IVectorService)svcmanager.get(dataServiceId);
        if (null == service) {
            throw new Exception("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5730\u56fe\u670d\u52a1\uff1a" + dataServiceId);
        }
        tileMogoDS = (MongodbDataSource)((IDataSourceInService)client.getDataSourcesManager().get(conf.mogoTileDbId)).getBean();
        System.out.println("=== config completed ===");
    }

    private static void cutData() throws Exception {
        l1 = 2;
        l2 = 8;
        ILayer layer = (ILayer)service.getLayerMap().values().iterator().next();
        String taskName = dataServiceName;
        String bbox = service.getBbox();
        TileLayerCutTask task = new TileLayerCutTask(taskName, layer, (IGridSystem)grid, tileMogoDS, Integer.valueOf(l1), Integer.valueOf(l2), LAYER_TYPE.layer, bbox);
        task.setResume(false);
        CountDownLatch latch = new CountDownLatch(1);
        TaskLauncher.launchTask((AbstractTileDispatchTask)task, latch);
        latch.await(10000000000L, TimeUnit.SECONDS);
        LOG.info("====== \u5207\u7247\u6d4b\u8bd5\u7ed3\u675f ==========");
        System.exit(0);
    }

    static {
        dataServiceName = "cut_matview";
        dataServiceId = "8b6ec26fe21f403b8e866311fe918407";
        levelDataFilters = new HashMap<String, Map<String, String>>();
    }
}

