/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.manager;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyHTTPClient {
    private static Logger logger = LoggerFactory.getLogger(MyHTTPClient.class);
    public static int maxIdleConnections = 4;
    public static int keepAliveDuration = 300;
    public static int ioTimeout = 30;
    private OkHttpClient okHttp;

    public MyHTTPClient(String user, String password) {
        this.createHttpClient(user, password);
    }

    public void createHttpClient(String user, String password) {
        TimeUnit tu = TimeUnit.SECONDS;
        this.okHttp = new OkHttpClient().newBuilder().connectionPool(new ConnectionPool(maxIdleConnections, (long)keepAliveDuration, tu)).connectTimeout((long)ioTimeout, tu).readTimeout((long)ioTimeout, tu).writeTimeout((long)ioTimeout, tu).hostnameVerifier((hostname, session) -> true).build();
    }

    public HttpResult postForm(String url, Map<String, Object> formData) throws Exception {
        try {
            FormBody.Builder builder = new FormBody.Builder();
            formData.forEach((key, val) -> builder.add(key, val.toString()));
            FormBody body = builder.build();
            Request request = new Request.Builder().url(url).post((RequestBody)body).build();
            Call call = this.okHttp.newCall(request);
            Response response = call.execute();
            this.handleResponse(response);
            return new HttpResult(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public HttpResult postJson(String url, String data) throws Exception {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (byte[])data.getBytes(StandardCharsets.UTF_8));
            Request request = new Request.Builder().url(url).post(body).build();
            Call call = this.okHttp.newCall(request);
            Response response = call.execute();
            this.handleResponse(response);
            return new HttpResult(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public HttpResult putJson(String url, String data) throws Exception {
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (byte[])data.getBytes(StandardCharsets.UTF_8));
            Request request = new Request.Builder().url(url).put(body).build();
            Call call = this.okHttp.newCall(request);
            Response response = call.execute();
            return new HttpResult(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public HttpResult getRequest(String url) throws Exception {
        try {
            Request request = new Request.Builder().url(url).get().build();
            Call call = this.okHttp.newCall(request);
            Response response = call.execute();
            return new HttpResult(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public HttpResult headRequest(String url) throws Exception {
        try {
            Request request = new Request.Builder().url(url).head().build();
            Call call = this.okHttp.newCall(request);
            Response response = call.execute();
            return new HttpResult(response);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw e;
        }
    }

    public void close() {
        try {
            this.okHttp.connectionPool().evictAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String handleResponse(Response response) throws IOException {
        return response.code() < 300 ? "OK" : "FAILED";
    }

    public class HttpResult {
        public int code;
        public String state;
        public String data;

        public HttpResult() {
        }

        public HttpResult(Response httpResponse) {
            this.code = httpResponse.code();
            this.state = httpResponse.message();
            try {
                this.data = httpResponse.body().string();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

