/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.ogr;

import com.github.javaparser.utils.Log;
import com.northpool.resources.datasource.ogr.FGDBDataSource;
import com.northpool.resources.datasource.ogr.connection.IOgrConnection;
import com.northpool.resources.datasource.ogr.shell.read.IOgrReadShell;
import com.northpool.thindriver.gdal.GDALInitializer;
import java.util.HashSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.gdal.ogr.DataSource;
import org.gdal.ogr.Feature;
import org.gdal.ogr.Layer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FGDBQuery {
    private static Logger logger = LoggerFactory.getLogger(FGDBQuery.class);
    private static String _fgdbPath = "E:\\Data\\EsriGDB\\dltb42.gdb";
    private static String _layerName = "DLTB420102";

    public static void main(String[] args) {
        try {
            FGDBQuery.setUp();
            FGDBQuery.loadFileGDB();
            System.out.println("=== END ===");
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        GDALInitializer.initLibraries();
        logger.info("tmpdir: {}", (Object)System.getProperty("java.io.tmpdir"));
        logger.info("jna.libpath: {}", (Object)System.getProperty("jna.library.path"));
        System.out.println("=== config completed ===");
    }

    private static void loadFileGDB() throws Exception {
        Feature feature;
        int i;
        FGDBDataSource dataSource = new FGDBDataSource(_fgdbPath);
        IOgrConnection conn = dataSource.connection();
        IOgrReadShell reader = conn.getReadShell();
        DataSource ogrds = reader.getDataSource();
        logger.info("\n format:{}\n source:{}\n layersCount:{}\n firstLayer:{}\n", new Object[]{ogrds.GetDriver().GetName(), ogrds.getName(), ogrds.GetLayerCount(), ogrds.GetLayer(0).GetName()});
        Layer firstLayer = ogrds.GetLayer(_layerName);
        long n1 = firstLayer.GetFeatureCount();
        logger.info(" layer {} all features count: {}", (Object)_layerName, (Object)n1);
        String sql = "select dlbm,dlmc from " + _layerName + " where (dlbm= '0103' ) OR ( dlbm= '0701' ) OR ( dlbm= '0302' )  OR ( dlbm= '0403' )  OR ( dlbm= '0702' )  OR ( dlbm= '1106' )  OR ( dlbm= '1103' )  OR ( dlbm= '0101' )  OR ( dlbm= '0809' )  OR ( dlbm= '1102' )  OR ( dlbm= '1107' )  ";
        Layer ogrLayer2 = ogrds.ExecuteSQL(sql, null, "SQLite");
        long n2 = ogrLayer2.GetFeatureCount();
        logger.info("queried layer features count: {}", (Object)n2);
        boolean printLayer = false;
        if (printLayer) {
            System.out.println();
            int fieldCount = ogrLayer2.GetLayerDefn().GetFieldCount();
            for (i = 0; i < fieldCount; ++i) {
                System.out.print(ogrLayer2.GetLayerDefn().GetFieldDefn(i).GetName() + "(" + ogrLayer2.GetLayerDefn().GetFieldDefn(i).GetTypeName() + ") ");
            }
            System.out.println("\n---------------------");
            i = 0;
            while ((long)i < n2 && null != (feature = ogrLayer2.GetNextFeature())) {
                System.out.print(i + 1 + " - ");
                for (int k = 0; k < fieldCount; ++k) {
                    System.out.print(feature.GetFieldAsString(k) + ", ");
                }
                System.out.println();
                ++i;
            }
        }
        HashSet<String> dlbms = new HashSet<String>();
        i = 0;
        while ((long)i < n2 && null != (feature = ogrLayer2.GetNextFeature())) {
            String fldVal = feature.GetFieldAsString("dlbm");
            dlbms.add(fldVal);
            ++i;
        }
        int n = dlbms.size();
        logger.info("result {} types. detail: {}", (Object)n, (Object)StringUtils.join(dlbms, (char)','));
    }
}

