/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.utils;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolABC {
    public static int MAX_PROCESS_NUM = 1;
    public static int MAX_QUEUE_SIZE = 2;

    public static void main(String[] args) {
        ThreadPoolABC.testWaitTimeout();
    }

    public static void testPoolShutdown() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(MAX_PROCESS_NUM, MAX_PROCESS_NUM, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(MAX_QUEUE_SIZE), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
            }
        });
        executorService.submit(new CancelableTask());
        executorService.shutdown();
        Future<Void> future = executorService.submit(new CancelableTask());
        boolean cancelTask = true;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (cancelTask) {
            boolean canceled = future.cancel(true);
            if (canceled) {
                System.out.println("\u4efb\u52a1\u5df2\u53d6\u6d88");
            } else {
                System.out.println("\u4efb\u52a1\u53d6\u6d88\u5931\u8d25");
            }
            boolean isFinished = future.isCancelled();
            if (isFinished) {
                try {
                    future.get();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        executorService.shutdownNow();
    }

    public static void testInterrupted() {
        InterruptedTask interruptedTask = new InterruptedTask();
        Thread interruptedThread = new Thread(interruptedTask);
        interruptedThread.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        interruptedThread.interrupt();
    }

    public static void testWaitTimeout() {
        TMOTask task = new TMOTask();
        CompletableFuture<Void> promise = CompletableFuture.runAsync(task);
        FutureTask<Object> task2 = new FutureTask<Object>(new InterruptedTask(), null);
        CompletableFuture<Void> promise2 = CompletableFuture.runAsync(task2);
        try {
            promise.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean cancelled = promise.cancel(true);
            if (cancelled) {
                System.out.println("\u4efb\u52a1\u5df2\u53d6\u6d88");
            } else {
                System.out.println("\u4efb\u52a1\u65e0\u6cd5\u53d6\u6d88");
            }
            task2.cancel(true);
        }
        System.out.println("===\u5916\u90e8\u7b49\u5f85\u4efb\u52a1\u6267\u884c\uff0c\u5df2\u8d85\u65f6 ==");
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("is cancelled: " + promise.isCancelled());
        System.out.println("is done: " + promise.isDone());
        System.out.println("is completed Exceptionally: " + promise.isCompletedExceptionally());
        System.out.println("FJPool running tasks: " + ForkJoinPool.commonPool().getActiveThreadCount());
    }

    static class TMOTask
    implements Runnable {
        TMOTask() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            int i = 0;
            try {
                while (true) {
                    Thread.sleep(1000L);
                    System.out.println("task is working " + i++);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                System.out.println("TMOTask finished");
                return;
            }
        }
    }

    static class InterruptedTask
    implements Runnable {
        InterruptedTask() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (true) {
                if (currentThread.isInterrupted()) {
                    System.out.println("\u6355\u83b7\u5230\u4e2d\u65ad\u72b6\u6001");
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break;
                }
            }
            System.out.println("InterruptedTask \u7ed3\u675f");
        }
    }

    static class CancelableTask
    implements Callable<Void> {
        CancelableTask() {
        }

        @Override
        public Void call() throws Exception {
            System.out.println("\u4efb\u52a1\u5f00\u59cb\u6267\u884c\u4e2d\u3002\u3002");
            boolean isCancelled = false;
            try {
                while (!isCancelled) {
                    isCancelled = Thread.currentThread().isInterrupted();
                }
            }
            finally {
                if (isCancelled) {
                    System.out.println("\u4efb\u52a1\u6267\u884c\u88ab\u53d6\u6d88" + Thread.currentThread().getName());
                }
            }
            Thread.sleep(10000L);
            return null;
        }
    }
}

