/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.buzidata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.javaparser.utils.Log;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.sfg.debugger.config.ConfBean;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckTileMongodb {
    private static Logger LOG = LoggerFactory.getLogger(CheckTileMongodb.class);
    static ConfBean conf;
    static Client client;
    static String collectionName;
    static MongodbFactory mogoFactory;

    public static void main(String[] args) {
        try {
            CheckTileMongodb.setUp();
            CheckTileMongodb.configMgpool();
        }
        catch (Exception e) {
            Log.error((String)e.getMessage(), (Supplier[])new Supplier[0]);
            e.printStackTrace();
        }
    }

    public static void setUp() throws Exception {
        System.out.println("=== before test===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        TileDispatchTaskManager.CUSTOM_THREAD_COUNT = 1;
        int poolSize = 2;
        DBPoolParameter.DEFAULT.setMaxActive(poolSize);
        conf = new ConfBean();
        client = new Client(CheckTileMongodb.conf.mogoBuziDB, CheckTileMongodb.conf.zkUrl, CheckTileMongodb.conf.mapserverUrl, true);
        String mogoUrl = "mongodb://localhost:27017/vtile2024v3_vector";
        MongodbDataSource mongodbDataSource = new MongodbDataSource(mogoUrl);
        mogoFactory = mongodbDataSource.factory();
    }

    private static void configMgpool() {
        CheckTileMongodb.setMongoPoolConfig(null);
    }

    public static void setMongoPoolConfig(String mgpoolCfgJson) {
        try {
            if (StringUtils.isBlank((CharSequence)mgpoolCfgJson)) {
                return;
            }
            JSONObject jobj = JSON.parseObject((String)mgpoolCfgJson);
            Integer min = jobj.getInteger("minPoolSize");
            Integer max = jobj.getInteger("maxPoolSize");
            Integer maxIdle = jobj.getInteger("maxIdleTimeMS");
            if (null != min && min >= 0) {
                GlobalTileSettings.MGPOOL_MIN = min;
            }
            if (null != max && max > 0) {
                GlobalTileSettings.MGPOOL_MAX = max;
            }
            if (null != maxIdle && maxIdle > 0) {
                GlobalTileSettings.MGPOOL_IDLE_TIMEOUT_MS = maxIdle;
            }
            System.out.println("\u5df2\u8bbe\u7f6emongo\u8fde\u63a5\u6c60\u53c2\u6570\uff1a" + mgpoolCfgJson);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void checkWork() throws Exception {
        collectionName = "Shp1234_utfgrid";
        MongoCollection coll = mogoFactory.getCollection(collectionName);
        long count = coll.countDocuments();
        System.out.println(count);
        System.out.println("\u51c6\u5907\u64cd\u4f5cutfgrid\u96c6\u5408");
        for (int i = 0; i < 4; ++i) {
            int curr = i + 1;
            coll.countDocuments();
            Document qry = new Document();
            qry.put("fx", (Object)6);
            qry.put("fy", (Object)1);
            qry.put("flevel", (Object)4);
            coll.find((Bson)qry).projection((Bson)new Document("_id", (Object)1)).first();
            LOG.info("{} ", (Object)curr);
            Document newDoc = new Document();
            newDoc.put("flayers", (Object)"{\"myshp\":\"all\",\"myshp_\u6ce8\u8bb0\":\"all\"}");
            newDoc.put("ffilterLevel", (Object)13);
            newDoc.put("fx", (Object)103);
            newDoc.put("fy", (Object)22);
            newDoc.put("flevel", (Object)8);
            newDoc.put("fisLayout", (Object)1);
            ArrayList<Document> list = new ArrayList<Document>();
            list.add(newDoc);
            coll.withWriteConcern(WriteConcern.UNACKNOWLEDGED).insertMany(list);
        }
        Thread.sleep(10000L);
    }
}

