/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.hbase;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.northpool.resources.datasource.hbase.HbaseDatasource;
import com.northpool.resources.datasource.hbase.connection.HbaseConnection;
import com.northpool.resources.hbasemeta.HBaseTableMeta;
import java.util.List;

public class TestHBaseDS {
    public static void main(String[] args) {
        String url = "hbase://172.16.62.11:2181,172.16.62.12:2181/geoway";
        try {
            HbaseDatasource ds = new HbaseDatasource(url, null);
            HbaseConnection conn = ds.connection();
            List list = HBaseTableMeta.getTableList((HbaseConnection)conn);
            list.forEach(System.out::println);
            String tableName = "shiji_xzqh";
            Boolean existOne = HBaseTableMeta.exists((HbaseConnection)conn, (String)tableName);
            if (!existOne.booleanValue()) {
                System.err.println("\u4e0d\u5b58\u5728\uff1a" + tableName);
                return;
            }
            int geoType = HBaseTableMeta.getGeometryType((HbaseConnection)conn, (String)tableName);
            String wkt = HBaseTableMeta.getExtentWKT((HbaseConnection)conn, (String)tableName);
            int srid = HBaseTableMeta.getSRID((HbaseConnection)conn, (String)tableName);
            List flds = HBaseTableMeta.getFields((HbaseConnection)conn, (String)tableName);
            System.out.println("\n === \u8be6\u60c5\uff1a" + tableName + " === \n");
            System.out.println("\u51e0\u4f55\u7c7b\u578b\uff1a " + geoType);
            System.out.println("SRID = " + srid);
            System.out.println("BBOX = " + wkt);
            System.out.println("Total: " + HBaseTableMeta.count((HbaseConnection)conn, (String)tableName));
            System.out.println("Fields Count: " + flds.size());
            ObjectMapper objmapper = new ObjectMapper();
            objmapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
            objmapper.enable(SerializationFeature.INDENT_OUTPUT);
            List feats = HBaseTableMeta.getData((HbaseConnection)conn, (String)tableName, (int)0, (int)1);
            if (feats.size() > 0) {
                String objstr = objmapper.writeValueAsString(feats.get(0));
                System.out.println("First feature:\n" + objstr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

