/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.utils;

import java.util.Arrays;

public class JenksNaturalBreaks {
    public static double[] findBreaks(double[] data, int numClasses) {
        double[] sortedData = Arrays.copyOf(data, data.length);
        Arrays.sort(sortedData);
        int n = sortedData.length;
        double[][] sumsOfSquares = new double[n + 1][numClasses + 1];
        int[][] optimalBreaks = new int[n + 1][numClasses + 1];
        for (int i = 1; i <= n; ++i) {
            sumsOfSquares[i][1] = JenksNaturalBreaks.calculateSumOfSquares(sortedData, 0, i);
        }
        for (int j = 2; j <= numClasses; ++j) {
            for (int i = j; i <= n; ++i) {
                sumsOfSquares[i][j] = Double.MAX_VALUE;
                for (int k = j - 1; k <= i - 1; ++k) {
                    double sum = sumsOfSquares[k][j - 1] + JenksNaturalBreaks.calculateSumOfSquares(sortedData, k, i);
                    if (!(sum < sumsOfSquares[i][j])) continue;
                    sumsOfSquares[i][j] = sum;
                    optimalBreaks[i][j] = k;
                }
            }
        }
        double[] breaks = new double[numClasses - 1];
        int k = n;
        for (int j = numClasses; j >= 2; --j) {
            k = optimalBreaks[k][j];
            breaks[j - 2] = sortedData[k];
        }
        return breaks;
    }

    public static double calculateSumOfSquares(double[] data, int start, int end) {
        double sum = 0.0;
        double mean = JenksNaturalBreaks.calculateMean(data, start, end);
        for (int i = start; i < end; ++i) {
            double deviation = data[i] - mean;
            sum += deviation * deviation;
        }
        return sum;
    }

    public static double calculateMean(double[] data, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            sum += data[i];
        }
        return sum / (double)(end - start);
    }

    public static void main(String[] args) {
        double[] data = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        int numClasses = 3;
        double[] breaks = JenksNaturalBreaks.findBreaks(data, numClasses);
        System.out.println("Breaks:");
        for (double value : breaks) {
            System.out.println(value);
        }
    }
}

