/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.utils;

import com.sfg.debugger.utils.JenksNaturalBreaks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NaturalBreaks {
    public static void main(String[] args) {
        double[] data = new double[]{100.0, 100.0, 100.0, 100000.0, 200.0};
        int numClasses = 3;
        ArrayList<Double> dalist = new ArrayList<Double>();
        Arrays.stream(data).forEach(dalist::add);
        FisherJenks jenks = new FisherJenks(dalist, numClasses);
        double[] breaks = jenks.classify();
        System.out.println("Fisher\u5206\u7ea7\uff1a\n" + StringUtils.join((double[])breaks, (char)','));
        System.out.println("--------- \u65b9\u6cd52 -------------");
        double[] vals = data;
        long start = System.currentTimeMillis();
        List<Double> d = NaturalBreaks.GetBreaks(vals, numClasses);
        for (int i = 0; i < d.size(); ++i) {
            System.out.println(d.get(i));
        }
        long end = System.currentTimeMillis();
        System.out.println("start time:" + start + "; end time:" + end + "; Run Time:" + (end - start) + "(ms)");
        System.out.println("--------- \u65b9\u6cd53 -------------");
        System.out.println("\u65b9\u6cd53\u7ed3\u679c\uff1a " + StringUtils.join((double[])JenksNaturalBreaks.findBreaks(data, numClasses), (char)','));
    }

    private static double[] getData1001() {
        return new double[]{1031.04, 3708.85, 378.94, 412.54, 1472.61, 3221.24, 14954.92, 283.57, 3701.39, 3690.92, 2234.14, 2829.64, 26814.23, 5857.47, 1167.81, 5388.35, 5318.2, 3746.01, 1527.01, 1490.86, 3584.17, 4141.81, 3933.46, 12840.43, 1123.6, 1389.56, 299.44, 1422.86, 467.54, 4549.5, 13053.51, 1807.01, 5311.11, 5408.64, 3043.62, 3041.89, 3889.86, 809.47, 1023.28, 608.48, 33958.2, 3866.27, 8301.34, 9958.99, 5390.45, 5301.56, 26055.29, 120.72, 560.68, 719.55, 4249.69, 3510.18, 951.36, 1320.5, 1477.26, 1332.34, 38546.1, 12206.01, 10524.83, 11518.13, 3116.26, 813.6, 1419.64, 2917.88, 385.16, 9011.42, 40856.92, 5284.93, 1639.73, 88.84, 25282.99, 840.56, 4198.61, 13909.27, 2726.65, 30693.73, 1964.89, 24083.03, 22957.4, 4465.2, 10441.28, 3856.84, 24983.17, 1859.6, 1165.21, 27488.84, 10277.37, 3540.76, 2063.57, 4026.28, 8073.71, 573.19, 7475.22, 1010.06, 3028.32, 160.71, 1812.14, 6978.21, 7416.89, 38146.97, 72634.84, 7186.93, 21623.34, 1315.13, 114.9, 902.56, 6131.97, 855.69, 3968.02, 15432.0, 6238.03, 1456.64, 1641.37, 2038.47, 498.34, 5347.24, 1097.28, 4804.04, 4163.35, 774.25, 2823.65, 98.05, 745.0, 3509.14, 2505.13, 714.36, 354.81, 2110.19, 347.93, 10751.51, 11562.41, 5165.19, 3069.84, 1944.16, 8626.21, 3358.22, 870.1, 17038.39, 19130.17, 1461.84, 1505.32, 3123.52, 11760.52, 19705.72, 891.4, 591.85, 19511.63, 7720.67, 2972.75, 2678.04, 280.25, 44897.38, 5354.52, 342.36, 446.33, 109.11, 359.84, 4207.69, 11281.08, 7397.73, 2090.27, 3386.41, 497.3, 1328.86, 5548.3, 1521.54, 18259.47, 6362.69, 10189.28, 54017.36, 42196.78, 10684.83, 813.62, 5917.66, 945.47, 25168.21, 3045.32, 4566.29, 3946.22, 10266.52, 3131.51, 25732.98, 14103.02, 34422.93, 1993.09, 10306.22, 167.31, 15871.15, 920.64, 26141.56, 9180.41, 16715.89, 71282.99, 1607.93, 10818.32, 2207.5, 6618.09, 26857.31, 8084.91, 445.77, 14361.5, 4818.81, 3962.82, 3527.26, 1034.46, 649.9, 2648.2, 3949.32, 4361.22, 1142.25, 433.95, 1944.46, 5069.61, 891.67, 3938.69, 1199.54, 1319.46, 1101.11, 5784.79, 5194.36, 9762.35, 530.4, 1828.63, 5225.19, 110524.19, 16443.49, 1709.31, 3435.2, 2695.56, 4793.95, 851.21, 2736.72, 540.99, 2060.91, 11429.47, 3275.53, 732.6, 651.14, 2900.44, 994.06, 3014.09, 23619.7, 2657.37, 2923.8, 2940.59, 1965.27, 1201.42, 2067.82, 16985.59, 4632.96, 596.53, 530.84, 1738.6, 795.71, 412.91, 538.2, 648.57, 2520.02, 1664.2, 1724.04, 400.08, 2877.48, 1018.66, 3600.2, 6929.29, 12613.05, 464.65, 13623.35, 875.72, 473.44, 1032.82, 460.65, 2391.12, 6650.66, 703.44, 26984.88, 18920.27, 4767.9, 5300.58, 572.24, 28387.88, 2959.96, 2631.3, 2510.67, 2461.75, 792.31, 25828.87, 1248.34, 10950.43, 2756.09, 763.51, 25436.56, 6907.11, 626.88, 877.65, 2743.55, 19667.95, 4204.56, 1643.51, 7527.47, 711.49, 19854.58, 9847.26, 21491.1, 2252.49, 6693.96, 1435.82, 632.01, 146.19, 2620.99, 3428.61, 2656.21, 290.51, 24114.1, 3704.27, 697.13, 640.23, 3703.44, 1895.32, 18859.04, 2490.55, 803.17, 2888.95, 702.93, 3926.32, 994.0, 6357.64, 592.94, 992.45, 504.69, 217.68, 2430.8, 4172.02, 4058.31, 940.05, 6430.72, 2612.66, 18465.46, 6009.76, 6889.04, 4211.33, 892.37, 51628.72, 3956.77, 882.35, 7064.83, 246.87, 6616.26, 22089.2, 3026.15, 19397.27, 691.07, 4611.07, 1053.28, 988.68, 12066.48, 6119.28, 55064.53, 3225.19, 17235.24, 4119.48, 1820.66, 9539.36, 14021.29, 2518.65, 3035.82, 79.77, 966.01, 1448.9, 757.01, 2116.39, 3137.81, 5490.63, 3801.89, 1919.45, 6823.8, 78.53, 1048.66, 28814.13, 868.7, 2269.94, 19354.09, 239.37, 2246.05, 4936.56, 3831.16, 174.11, 5048.06, 7531.13, 1819.36, 1220.04, 6456.04, 5824.19, 80602.47, 15129.1, 15529.93, 22285.88, 2696.69, 48721.35, 626.29, 1388.48, 3282.94, 3480.86, 3209.75, 963.61, 438.49, 45527.81, 955.64, 137.8, 571.73, 1281.22, 2012.5, 21975.02, 9609.75, 638.58, 66830.69, 2692.38, 880.65, 1345.59, 2252.98, 1476.77, 7348.32, 1636.31, 2468.06, 2657.04, 291.77, 3475.99, 477.97, 859.64, 9686.48, 758.4, 452.28, 519.02, 6328.45, 213.42, 1247.59, 773.2, 6356.03, 26118.36, 1089.5, 3740.95, 4399.45, 1015.01, 4227.18, 513.35, 492.46, 11240.56, 10317.85, 2656.52, 1245.66, 2485.87, 429.94, 661.15, 1133.36, 354.72, 116.37, 1127.92, 46498.76, 1782.18, 59.85, 2013.48, 872.84, 4095.05, 14570.93, 766.61, 489.06, 3142.12, 165.74, 38307.7, 41407.96, 1608.95, 63450.42, 44499.66, 854.57, 623.0, 8766.41, 7495.48, 663.6, 2632.52, 1292.24, 1785.01, 920.58, 8607.62, 531.46, 759.82, 423.66, 359.04, 766.36, 138.56, 349.08, 20830.61, 4395.98, 1199.54, 1885.46, 4296.67, 11730.64, 1105.12, 2661.17, 2088.37, 3038.86, 719.57, 198.03, 18192.37, 14736.2, 167.37, 17742.47, 11375.97, 136.55, 15119.43, 171.51, 460.16, 1500.08, 1797.36, 3348.97, 8262.14, 9378.12, 11285.35, 6756.74, 4594.42, 56482.46, 3989.32, 1758.82, 2253.25, 4225.88, 150.92, 5044.6, 1764.89, 8626.32, 2169.47, 1441.72, 1455.34, 285.96, 3473.85, 7392.52, 2402.33, 359.39, 25292.22, 181.73, 49693.17, 5246.82, 1710.1, 2473.14, 1379.39, 487.53, 2213.77, 1533.34, 46805.53, 197.02, 1043.1, 22327.16, 1380.08, 2651.95, 3541.19, 4673.75, 69445.12, 8286.5, 487.82, 11856.02, 969.0, 1543.5, 1439.35, 1197.35, 2555.13, 714.41, 695.56, 364.47, 1230.95, 1095.11, 3952.29, 1065.92, 232.98, 71.39, 969.55, 4740.45, 827.82, 1519.35, 1960.08, 440.73, 7951.72, 16857.32, 793.8, 14327.29, 29454.01, 6119.98, 3320.47, 1102.1, 34820.12, 4255.61, 11591.65, 4064.38, 10065.38, 29997.65, 7339.45, 1915.17, 8554.44, 1464.25, 419.91, 2444.6, 14542.52, 2041.38, 1236.09, 751.58, 1134.76, 9612.96, 1499.53, 653.03, 2120.64, 15869.23, 7514.74, 962.49, 1624.26, 2901.33, 12866.9, 593.91, 5776.24, 16199.86, 718.58, 1049.64, 4536.0, 9810.24, 5110.09, 12868.2, 4968.9, 227.16, 953.16, 545.76, 220.02, 16296.33, 764.4, 1708.36, 1098.5, 2995.08, 423.66, 728.32, 3279.78, 2301.96, 1924.54, 975.37, 1484.88, 1104.55, 7794.27, 9392.25, 4316.14, 1907.89, 3663.88, 872.42, 1465.5, 3493.87, 835.33, 1818.67, 1813.88, 583.04, 921.06, 7836.59, 9462.46, 2352.37, 2569.6, 1578.51, 1895.08, 2280.22, 1958.5, 1051.73, 330.74, 14279.49, 12469.79, 1435.49, 3176.03, 7580.66, 435.11, 4714.9, 2270.81, 26603.52, 2515.88, 1750.63, 1235.95, 738.88, 548.52, 877.08, 66110.81, 27020.43, 12752.44, 13405.99, 18865.19, 6223.26, 6002.4, 29714.2, 1988.16, 2082.8, 3010.37, 870.17, 672.05, 279.2, 8444.47, 918.73, 3396.97, 41994.25, 13408.29, 15572.33, 1373.36, 239.07, 3445.54, 1963.8, 3764.55, 10917.21, 3014.45, 1964.08, 5416.04, 883.55, 650.93, 3165.09, 198.21, 5909.66, 402.8, 3775.68, 10269.89, 365.89, 219.27, 4067.04, 1575.09, 1229.58, 63906.76, 28846.67, 1937.03, 173889.34, 13465.12, 13198.1, 33729.91, 103.06, 685.51, 1442.33, 512.05, 851.61, 348.2, 283.19, 3833.31, 762.44, 14897.43, 50045.67, 11128.76, 755.06, 5028.89, 233.18, 2532.02, 5469.32, 11790.84, 11407.5, 3785.34, 2400.57, 225.73, 2275.55, 193.27, 4539.88, 52370.04, 2374.18, 3464.47, 26434.31, 120.78, 2613.59, 4172.48, 4760.45, 8912.31, 9993.44, 1984.07, 8825.32, 674.92, 314.03, 763.92, 197.32, 6004.23, 504.2, 7599.0, 94.65, 12972.59, 8575.73, 373.25, 2287.47, 640.66, 800.16, 2987.68, 2138.08, 4039.1, 716.86, 2240.37, 6514.84, 4797.22, 1070.26, 2578.87, 1980.11, 309.85, 4089.46, 85.64, 5986.84, 17888.52, 1000.84, 26890.84, 4637.31, 5055.7, 535.05, 125.33, 551.16, 2485.04, 3505.03, 2147.14, 8390.3, 882.36, 761.48, 748.87, 879.5, 52.01, 3738.28, 5367.21, 2300.05, 7768.96, 7577.46, 980.78, 4963.53, 136527.99, 3387.78, 2578.1, 5827.32, 1378.69, 310.23, 466.25, 12167.97, 717.03, 94.74, 1285.63, 1451.19, 6380.49, 4490.98, 627.85, 746.85, 335.62, 1291.37, 10543.08, 1762.49, 21825.45, 73889.38, 3132.23, 9429.91, 69.47, 1761.07, 1313.22, 5220.01, 3187.9, 610.79, 2119.51, 53.07, 819.91, 2565.47, 39969.24, 4873.13, 1331.13, 17171.01, 4054.15, 219.6, 666.26, 14040.96, 3908.84, 488.87, 602.67, 195.02, 2515.41, 27983.23, 160039.48, 948.09, 1681.62, 18624.89, 8303.23, 1090.85, 2377.51, 415.7, 4820.73, 12422.9, 5716.12, 3911.58, 3346.37, 1564.38, 487.19, 1874.64, 17296.82, 3357.22, 82.96, 957.98, 778.27, 791.7, 44518.55, 1855.99, 1220.7, 686.08, 125.2, 4155.85, 410.31, 273.83, 363.52, 167.25, 1318.89, 6947.0, 360.81, 1565.41, 154.38, 15769.88, 745.85, 234.72, 1621.4, 1505.31, 5110.31, 546.88, 736.25, 1340.01, 1031.96, 1168.12, 2954.2, 2591.57, 10572.13, 2210.88, 1904.5, 70075.74, 2783.05, 5247.1, 3328.53, 4189.08, 2740.68, 2321.58, 3617.82, 6000.14, 619.99, 10283.56, 2831.89, 813.03, 15573.58, 252.42, 9927.17, 1569.81, 1346.0, 860.32, 1648.36, 6821.49, 11270.4, 91.29, 3539.65, 731.44, 9710.21, 21317.83, 3910.45, 10406.48, 4246.73, 3917.77, 509.46, 6821.25, 494.3, 858.38, 7486.0, 949.91, 41628.5, 1503.04, 2516.33, 248.49, 582.45, 459.84, 4511.76, 521.28, 993.31, 3720.57, 25042.6, 1712.74, 20310.03, 1427.69, 837.88, 407.23, 6198.95, 1969.05, 1100.61, 1170.55, 944.35, 223.71, 106.11, 3284.68, 492.49, 181.62, 536.87, 5394.08, 209.05, 23912.61, 1357.35, 1787.29, 5251.13, 5487.59, 3447.12, 5176.43, 20435.29, 21519.51, 5631.93, 145.69, 633.83, 204.58, 1222.5, 7006.35, 7853.78, 4794.64, 1948.45};
    }

    public static List<Double> GetBreaks(double[] vals, int classCount) {
        if (vals.length < classCount) {
            throw new RuntimeException("\u5206\u7c7b\u7ea7\u6570" + classCount + "\u4e0d\u80fd\u591a\u4e8e\u6570\u636e\u4e2a\u6570\uff1a" + vals.length);
        }
        Arrays.sort(vals);
        LinkedHashMap<Double, Integer> counterMap = new LinkedHashMap<Double, Integer>();
        for (double v : vals) {
            if (counterMap.containsKey(v)) {
                counterMap.put(v, (Integer)counterMap.get(v) + 1);
                continue;
            }
            counterMap.put(v, 1);
        }
        ArrayList<Double> keyList = new ArrayList<Double>();
        Iterator iterator = counterMap.keySet().iterator();
        while (iterator.hasNext()) {
            double group_valsKey = (Double)iterator.next();
            keyList.add(group_valsKey);
        }
        int n = counterMap.size();
        int k = classCount;
        List<Integer[]> all_breaks = NaturalBreaks.getAllBreaks(n - 1, k - 1);
        double min_sum_sqd = Double.MAX_VALUE;
        Integer[] optimal_breaks = null;
        for (Integer[] breaks : all_breaks) {
            ArrayList<Integer> break_positions = new ArrayList<Integer>();
            break_positions.add(0);
            break_positions.addAll(Arrays.asList(breaks));
            break_positions.add(n);
            double sum_sqd = 0.0;
            for (int i = 0; i < break_positions.size() - 1; ++i) {
                int begin = (Integer)break_positions.get(i);
                int gap = (Integer)break_positions.get(i + 1) - begin;
                ArrayList<Double> class_vals = new ArrayList<Double>();
                for (int j = 0; j < gap; ++j) {
                    int key_index = begin + j;
                    double key = (Double)keyList.get(key_index);
                    int times = (Integer)counterMap.get(key);
                    for (int l = 0; l < times; ++l) {
                        class_vals.add(key);
                    }
                }
                sum_sqd += NaturalBreaks.SquareDeviation(class_vals);
            }
            if (!(sum_sqd < min_sum_sqd)) continue;
            min_sum_sqd = sum_sqd;
            optimal_breaks = breaks;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        Integer[] integerArray = optimal_breaks;
        int n2 = integerArray.length;
        for (int i = 0; i < n2; ++i) {
            int _break = integerArray[i].intValue();
            result.add((Double)keyList.get(_break));
        }
        return result;
    }

    private static List<Integer[]> getAllBreaks(int n, int k) {
        int[] r = new int[k + 1];
        ArrayList<Integer[]> rs = new ArrayList<Integer[]>();
        NaturalBreaks.combination(n, k, r, rs);
        return rs;
    }

    public static double SquareDeviation(List<Double> vals) {
        Double mean = vals.stream().mapToDouble(Double::doubleValue).sum() / (double)vals.size();
        Double doubles = 0.0;
        for (int i = 0; i < vals.size(); ++i) {
            doubles = doubles + (vals.get(i) - mean) * (vals.get(i) - mean);
        }
        return doubles / (double)vals.size();
    }

    private static void combination(int n, int k, int[] r, List<Integer[]> rs) {
        for (int i = n; i >= k; --i) {
            r[k] = i;
            if (k > 1) {
                NaturalBreaks.combination(i - 1, k - 1, r, rs);
                continue;
            }
            Integer[] removed = (Integer[])Arrays.stream(ArrayUtils.remove((int[])r, (int)0)).boxed().toArray(Integer[]::new);
            rs.add(removed);
        }
    }

    public static class FisherJenks {
        public ArrayList<Double> data;
        public int numClasses;
        private Double[][] matrix;
        private int[][] breakpoints;

        public FisherJenks(ArrayList<Double> values, int k) {
            this.data = values;
            this.numClasses = k;
        }

        public void buildMatrix() {
            this.matrix = new Double[this.data.size()][this.numClasses];
            this.breakpoints = new int[this.data.size()][this.numClasses];
            for (int j = 0; j < this.numClasses; ++j) {
                this.breakpoints[0][j] = 1;
                for (int i = 0; i < this.data.size(); ++i) {
                    this.matrix[i][j] = Double.MAX_VALUE;
                }
            }
            double variance = 0.0;
            for (int l = 0; l < this.data.size(); ++l) {
                double w = 0.0;
                double sum_squares = 0.0;
                double sum = 0.0;
                for (int m = 0; m <= l; ++m) {
                    int lower_class_limit = l - m;
                    double val = this.data.get(lower_class_limit);
                    variance = (sum_squares += val * val) - (sum += val) * sum / (w += 1.0);
                    int i4 = lower_class_limit - 1;
                    if (i4 <= -1) continue;
                    for (int j = 1; j < this.numClasses; ++j) {
                        double temp_val = variance + this.matrix[i4][j - 1];
                        if (!(this.matrix[l][j] >= temp_val)) continue;
                        this.breakpoints[l][j] = lower_class_limit + 1;
                        this.matrix[l][j] = temp_val;
                    }
                }
                this.breakpoints[l][0] = 1;
                this.matrix[l][0] = variance;
            }
        }

        public double[] classify() {
            this.data.sort(Comparator.comparing(Double::doubleValue));
            this.buildMatrix();
            int nbounds = this.numClasses + 1;
            int len_values = this.data.size();
            double[] breaks = new double[nbounds];
            breaks[0] = this.data.get(0);
            breaks[nbounds - 1] = this.data.get(len_values - 1);
            int m = len_values - 1;
            for (int j = this.numClasses - 1; j >= 1; --j) {
                int index = this.breakpoints[m][j] - 2;
                breaks[j] = this.data.get(index);
                m = index;
            }
            return breaks;
        }
    }
}

