/*
 * Decompiled with CFR 0.152.
 */
package com.sfg.debugger.ogr;

import com.geoway.vtile.spatial.grid.IGridSystem;
import com.geoway.vtile.spatial.grid.extent.GridExtent;
import com.geoway.vtile.spatial.grid.extent.impl.GridExtentImpl;
import com.geoway.vtile.spatial.grid.impl.quadtreegrid.TdtDegree512;
import com.geoway.vtile.tiledispatch.consumer.saver.SqliteTileSaver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBTilesWork {
    private static Logger LOG = LoggerFactory.getLogger(MBTilesWork.class);
    private static String jdbcPrefix = "jdbc:sqlite:";
    private static String dbfile = "E:\\Data\\mbtiles\\myshp.gpkg";

    public static void main(String[] args) {
        try {
            MBTilesWork.testSqliteSaver();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryTable() throws Exception {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(jdbcPrefix + dbfile);
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT id,name FROM myshp");
            while (rs.next()) {
                int id = rs.getInt("id");
                String name = rs.getString("name");
                System.out.println("ID: " + id + ", Name: " + name);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (null != conn) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeTilesTable() throws Exception {
        Connection conn = null;
        String tileTableName = "myshp2_tiles";
        try {
            conn = DriverManager.getConnection(jdbcPrefix + dbfile);
            Statement stmt = conn.createStatement();
            String sql = "CREATE TABLE IF NOT EXISTS " + tileTableName + " (zoom_level INTEGER NOT NULL,tile_column INTEGER NOT NULL,tile_row INTEGER NOT NULL,tile_data BLOB NOT NULL)";
            String index_sql = "CREATE INDEX idx_" + tileTableName + " ON " + tileTableName + "(zoom_level, tile_column, tile_row)";
            stmt.addBatch(sql);
            stmt.addBatch(index_sql);
            stmt.executeBatch();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        finally {
            if (null != conn) {
                conn.close();
            }
        }
    }

    private static void testSqliteSaver() {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        SqliteTileSaver saver = new SqliteTileSaver(dbfile, "sfgtest_tiles");
        saver.init();
        GridExtentImpl ext = new GridExtentImpl(0.0, 0.0, 0.0, 0.0, 7, (IGridSystem)new TdtDegree512(), 52, 11);
        byte[] bytesarr = new byte[]{64, 64, 64};
        Object[] arr = new Object[]{ext, bytesarr};
        datas.add(arr);
        saver.save(datas, null);
        saver.remove((List)new ArrayList<GridExtent>((GridExtent)ext){
            final /* synthetic */ GridExtent val$ext;
            {
                this.val$ext = gridExtent;
                this.add(this.val$ext);
            }
        });
    }
}

